
<?php $__env->startSection('content'); ?>
<style>
.table > :not(caption) > * > * {
  color: var(--vz-table-color-state), var(--vz-table-color-type, var(--vz-table-color));
  font-size: 12px;
}
</style>
<div class="page-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Digital Product Card Entry</h4>
                    <div class="page-title-right">
                        <!-- <button class="btn btn-outline-secondary me-2"><i class="fas fa-print"></i> Print</button> -->
                        <!-- <button class="btn btn-primary"><i class="fas fa-save"></i> Save Card</button> -->
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title text-center mb-0">PRODUCT CARD</h5>
                    </div>
                    <div class="card-body">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo e(session('success')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        <form method="POST" action="<?php echo e(route('product.store')); ?>" onsubmit="return validateForm()" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row justify-content-center">
                                <!-- Left Column -->
                                <div class="col-md-4">
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm">Product Name <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control form-control-sm" name="product_name" placeholder="Enter Product Name" required>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm"><?php echo e($dropdownFields['co_deisgn']['field_label']); ?> <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <select class="form-select form-select-sm" name="co_design" required>
                                                <option value="">Select <?php echo e($dropdownFields['co_deisgn']['field_label']); ?></option>
                                                <?php if(isset($dropdownFields['co_deisgn'])): ?>
                                                    <?php $__currentLoopData = $dropdownFields['co_deisgn']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($option->id); ?>"
                                                            <?php echo e(old('co_deisgn') == $option->id ? 'selected' : ''); ?>>
                                                            <?php echo e($option->option_value); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm"><?php echo e($dropdownFields['standard_size']['field_label']); ?> <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <select class="form-select form-select-sm" name="standard_size" required>
                                                <option value="">Select <?php echo e($dropdownFields['standard_size']['field_label']); ?></option>
                                                <?php if(isset($dropdownFields['standard_size'])): ?>
                                                    <?php $__currentLoopData = $dropdownFields['standard_size']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($option->id); ?>"
                                                            <?php echo e(old('standard_size') == $option->id ? 'selected' : ''); ?>>
                                                            <?php echo e($option->option_value); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm"><?php echo e($dropdownFields['color']['field_label']); ?> <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <select class="form-select form-select-sm" name="color" required>
                                                <option value="">Select <?php echo e($dropdownFields['color']['field_label']); ?></option>
                                                <?php if(isset($dropdownFields['color'])): ?>
                                                    <?php $__currentLoopData = $dropdownFields['color']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($option->id); ?>"
                                                            <?php echo e(old('color') == $option->id ? 'selected' : ''); ?>>
                                                            <?php echo e($option->option_value); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm"><?php echo e($dropdownFields['collection']['field_label']); ?> <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <select class="form-select form-select-sm" name="collection" required>
                                                <option value="">Select <?php echo e($dropdownFields['collection']['field_label']); ?></option>
                                                <?php if(isset($dropdownFields['collection'])): ?>
                                                    <?php $__currentLoopData = $dropdownFields['collection']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($option->id); ?>"
                                                            <?php echo e(old('collection') == $option->id ? 'selected' : ''); ?>>
                                                            <?php echo e($option->option_value); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm"><?php echo e($dropdownFields['shape']['field_label']); ?> <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <select class="form-select form-select-sm" name="shape" required>
                                                <option value="">Select <?php echo e($dropdownFields['shape']['field_label']); ?></option>
                                                <?php if(isset($dropdownFields['shape'])): ?>
                                                    <?php $__currentLoopData = $dropdownFields['shape']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($option->id); ?>"
                                                            <?php echo e(old('shape') == $option->id ? 'selected' : ''); ?>>
                                                            <?php echo e($option->option_value); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm"><?php echo e($dropdownFields['style']['field_label']); ?> <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <select class="form-select form-select-sm" name="style" required>
                                                <option value="">Select <?php echo e($dropdownFields['style']['field_label']); ?></option>
                                                <?php if(isset($dropdownFields['style'])): ?>
                                                    <?php $__currentLoopData = $dropdownFields['style']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($option->id); ?>"
                                                            <?php echo e(old('style') == $option->id ? 'selected' : ''); ?>>
                                                            <?php echo e($option->option_value); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm"><?php echo e($dropdownFields['customer_design']['field_label']); ?> <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <select class="form-select form-select-sm" name="customer_design" required>
                                                <option value="">Select <?php echo e($dropdownFields['customer_design']['field_label']); ?></option>
                                                <?php if(isset($dropdownFields['customer_design'])): ?>
                                                    <?php $__currentLoopData = $dropdownFields['customer_design']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($option->id); ?>"
                                                            <?php echo e(old('customer_design') == $option->id ? 'selected' : ''); ?>>
                                                            <?php echo e($option->option_value); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm">Product Card No. <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control form-control-sm" id="product_card_no" name="product_card_no" placeholder="Enter Product Card No" readonly required>
                                            <button type="button" class="btn btn-sm btn-outline-primary mt-1" onclick="generateCardNo()">Generate</button>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm"><?php echo e($dropdownFields['quality']['field_label']); ?> <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <select class="form-select form-select-sm" name="quality" required>
                                                <option value="">Select <?php echo e($dropdownFields['quality']['field_label']); ?></option>
                                                <?php if(isset($dropdownFields['quality'])): ?>
                                                    <?php $__currentLoopData = $dropdownFields['quality']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($option->id); ?>"
                                                            <?php echo e(old('quality') == $option->id ? 'selected' : ''); ?>>
                                                            <?php echo e($option->option_value); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm"><?php echo e($dropdownFields['weave']['field_label']); ?> <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <select class="form-select form-select-sm" name="weave" required>
                                                <option value="">Select <?php echo e($dropdownFields['weave']['field_label']); ?></option>
                                                <?php if(isset($dropdownFields['weave'])): ?>
                                                    <?php $__currentLoopData = $dropdownFields['weave']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($option->id); ?>"
                                                            <?php echo e(old('weave') == $option->id ? 'selected' : ''); ?>>
                                                            <?php echo e($option->option_value); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-sm-4 col-form-label col-form-label-sm">CAD (Design Photo) <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <input type="file" class="form-control form-control-sm" id="cad_photo" name="cad_photo" accept="image/*" required>
                                            <div id="cad_preview" class="mt-2" style="display: none;">
                                                <img id="cad_image" src="" alt="CAD Preview" class="img-thumbnail">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Right Column -->
                                <div class="col-md-5">
                                    <!-- Shade Table -->
                                    <div class="table-responsive mb-2">
                                        <table class="table table-bordered table-sm">
                                            <thead class="table-light">
                                                <tr>
                                                    <th width="5%">S.No.</th>
                                                    <th width="35%">Yarn <span class="text-danger">*</span></th>
                                                    <th width="35%">Shade No. <span class="text-danger">*</span></th>
                                                    <th width="10%">Percentage</th>
                                                    <th width="15%">Kilogram</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php for($i = 1; $i <= 20; $i++): ?>
                                                <tr>
                                                    <td class="text-center"><?php echo e($i); ?>.</td>
                                                    <td>
                                                        <select class="form-select form-select-sm yarn-select" name="yarn[<?php echo e($i); ?>]">
                                                            <option value="">Select <?php echo e($dropdownFields['yarn']['field_label']); ?></option>
                                                            <?php if(isset($dropdownFields['yarn'])): ?>
                                                                <?php $__currentLoopData = $dropdownFields['yarn']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($option->id); ?>"
                                                                        <?php echo e(old('yarn.' . $i) == $option->id ? 'selected' : ''); ?>>
                                                                        <?php echo e($option->option_value); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <select class="form-select form-select-sm shade-select" name="shade[<?php echo e($i); ?>]">
                                                            <option value="">Select Shade</option>
                                                        </select>
                                                    </td>
                                                    <td><input type="number" class="form-control form-control-sm percentage-input" step="0.01" placeholder="0.00" name="percentage[<?php echo e($i); ?>]" readonly></td>
                                                    <td><input type="number" class="form-control form-control-sm kilogram-input" step="0.01" placeholder="0.000" name="kilogram[<?php echo e($i); ?>]" readonly></td>
                                                </tr>
                                                <?php endfor; ?>
                                            </tbody>
                                            <tfoot>
                                                <th colspan="3" class="text-end">Total</th>
                                                <th id="total-percentage">0.00</th>
                                                <th id="total-kilogram">0.000</th>
                                            </tfoot>
                                        </table>
                                    </div>

                                    <!-- Yarn Issue and Received Yarn -->
                                    <!-- <div class="row">
                                        <div class="col-6">
                                            <h6 class="text-center mb-3">YARN ISSUE</h6>
                                            <div class="mb-3">
                                                <label class="form-label">WOOL YARN</label>
                                                <div class="row">
                                                    <div class="col-6">
                                                        <input type="text" class="form-control form-control-sm" placeholder="Qty">
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="text" class="form-control form-control-sm" placeholder="Rate">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">TEDHA</label>
                                                <input type="text" class="form-control form-control-sm">
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">80 NO TANI</label>
                                                <input type="text" class="form-control form-control-sm">
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">LACHI</label>
                                                <input type="text" class="form-control form-control-sm">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <h6 class="text-center mb-3">RECEIVED YARN</h6>
                                            <div class="mb-3">
                                                <label class="form-label">WOOL (Received)</label>
                                                <div class="row">
                                                    <div class="col-6">
                                                        <input type="text" class="form-control form-control-sm" placeholder="Kilogram">
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="text" class="form-control form-control-sm" placeholder="Rate">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>-->

                                    <div class="text-end">
                                        <button class="btn btn-primary" type="submit"><i class="fas fa-save"></i> Save Card</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<style>
.readonly-field {
    background-color: #dddee0 !important;
    color: #6c757d;
}
.filled-row {
    background-color: #e8f5e9 !important;
}
</style>

<script>
function validateForm() {
    let filledRows = 0;
    document.querySelectorAll('tbody tr').forEach(row => {
        const yarn = row.querySelector('.yarn-select').value;
        const shade = row.querySelector('.shade-select').value;
        if (yarn && shade) filledRows++;
    });
    
    if (filledRows < 5) {
        alert('Please fill at least 5 yarn and shade combinations.');
        return false;
    }
    return true;
}

function generateCardNo() {
    const prefix = 'PC';
    const timestamp = Date.now().toString().slice(-6);
    const random = Math.floor(Math.random() * 1000).toString().padStart(3, '0');
    document.getElementById('product_card_no').value = prefix + timestamp + random;
}

document.addEventListener('DOMContentLoaded', function() {
    // Yarn-Shade functionality
    const yarnSelects = document.querySelectorAll('.yarn-select');
    const shadeSelects = document.querySelectorAll('.shade-select');
    
    function checkRowInputs(row) {
        const yarnSelect = row.querySelector('.yarn-select');
        const shadeSelect = row.querySelector('.shade-select');
        const percentageInput = row.querySelector('.percentage-input');
        const kilogramInput = row.querySelector('.kilogram-input');
        
        if (yarnSelect.value && shadeSelect.value) {
            percentageInput.removeAttribute('readonly');
            kilogramInput.removeAttribute('readonly');
            percentageInput.classList.remove('readonly-field');
            kilogramInput.classList.remove('readonly-field');
        } else {
            percentageInput.setAttribute('readonly', true);
            kilogramInput.setAttribute('readonly', true);
            percentageInput.classList.add('readonly-field');
            kilogramInput.classList.add('readonly-field');
            percentageInput.value = '';
            kilogramInput.value = '';
            row.classList.remove('filled-row');
        }
        
        // Check if row is filled (all fields must have values)
        if (yarnSelect.value && shadeSelect.value && percentageInput.value && kilogramInput.value) {
            row.classList.add('filled-row');
        } else {
            row.classList.remove('filled-row');
        }
        
        calculateTotals();
    }
    
    function calculateTotals() {
        let totalPercentage = 0;
        let totalKilogram = 0;
        
        document.querySelectorAll('.percentage-input').forEach(input => {
            if (input.value) totalPercentage += parseFloat(input.value);
        });
        
        document.querySelectorAll('.kilogram-input').forEach(input => {
            if (input.value) totalKilogram += parseFloat(input.value);
        });
        
        document.getElementById('total-percentage').textContent = totalPercentage.toFixed(2);
        document.getElementById('total-kilogram').textContent = totalKilogram.toFixed(3);
    }
    
    yarnSelects.forEach(function(yarnSelect) {
        yarnSelect.addEventListener('change', function() {
            const yarnId = this.value;
            const row = this.closest('tr');
            const shadeSelect = row.querySelector('.shade-select');
            
            shadeSelect.innerHTML = '<option value="">Select Shade</option>';
            
            if (yarnId) {
                fetch(`<?php echo e(url('/api/shade-options')); ?>/${yarnId}`)
                    .then(response => response.json())
                    .then(data => {
                        data.forEach(shade => {
                            const option = document.createElement('option');
                            option.value = shade.id;
                            option.textContent = shade.option_value;
                            shadeSelect.appendChild(option);
                        });
                    })
                    .catch(error => {
                        console.error('Error fetching shade options:', error);
                    });
            }
            checkRowInputs(row);
        });
    });
    
    shadeSelects.forEach(function(shadeSelect) {
        shadeSelect.addEventListener('change', function() {
            checkRowInputs(this.closest('tr'));
        });
    });
    
    // Add event listeners for percentage and kilogram inputs
    document.querySelectorAll('.percentage-input, .kilogram-input').forEach(input => {
        input.addEventListener('input', function() {
            checkRowInputs(this.closest('tr'));
        });
        // Initial readonly styling
        if (input.hasAttribute('readonly')) {
            input.classList.add('readonly-field');
        }
    });
    
    // CAD Photo Preview
    const cadInput = document.getElementById('cad_photo');
    const cadPreview = document.getElementById('cad_preview');
    const cadImage = document.getElementById('cad_image');
    
    cadInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                cadImage.src = e.target.result;
                cadPreview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            cadPreview.style.display = 'none';
        }
    });
});
</script>
<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views/admin/product/create.blade.php ENDPATH**/ ?>