<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">Create New Lead</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Lead Management</a></li>
                                <li class="breadcrumb-item active">Create New Lead</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Lead Information</h4>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('lead.store')); ?>" method="POST" id="leadForm" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>

                                <!-- Basic Information -->
                                <h1 class="mt-1">Applicant Details</h1>
                                <section id="applicant_section"
                                    style="border-bottom: 2px dashed #7c7f90; padding-bottom: 50px;">
                                    <h4 class="mt-3">Basic Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="segment" class="form-label">Segment</label>
                                                <select class="form-select" id="segment" name="segment">
                                                    <option value="">Select Segment</option>
                                                    <?php if(isset($dropdownFields['segment'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['segment']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('segment') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="loan_type" class="form-label">Loan Type</label>
                                                <select class="form-select" id="loan_type" name="loan_type">
                                                    <option value="">Select Loan Type</option>
                                                    <?php if(isset($dropdownFields['loan_type'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['loan_type']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('loan_type') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="customer_type" class="form-label">Customer Type</label>
                                                <select class="form-select" id="customer_type" name="customer_type">
                                                    <option value="">Select Type</option>
                                                    <?php if(isset($dropdownFields['customer_type'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['customer_type']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('customer_type') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_first_name" class="form-label">First Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="applicant_first_name"
                                                    name="applicant_first_name" value="<?php echo e(old('applicant_first_name')); ?>">
                                                <?php $__errorArgs = ['applicant_first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_middle_name" class="form-label">Middle Name</label>
                                                <input type="text" class="form-control" id="applicant_middle_name"
                                                    name="applicant_middle_name"
                                                    value="<?php echo e(old('applicant_middle_name')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_last_name" class="form-label">Last Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="applicant_last_name"
                                                    name="applicant_last_name" value="<?php echo e(old('applicant_last_name')); ?>">
                                                <?php $__errorArgs = ['applicant_last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="father_name" class="form-label">Father Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="father_name"
                                                    name="father_name" value="<?php echo e(old('father_name')); ?>">
                                                <?php $__errorArgs = ['father_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="caste" class="form-label">Caste</label>
                                                <select class="form-select" id="caste" name="caste">
                                                    <option value="">Select Caste</option>
                                                    <?php if(isset($dropdownFields['caste'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['caste']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('caste') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="dob" class="form-label">DOB</label>
                                                <input type="date" class="form-control" id="dob" name="dob"
                                                    value="<?php echo e(old('dob')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="age" class="form-label">Age</label>
                                                <input type="number" class="form-control" id="age" name="age"
                                                    value="<?php echo e(old('age')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="gender" class="form-label">Gender</label>
                                                <select class="form-select" id="gender" name="gender">
                                                    <option value="">Select Gender</option>
                                                    <?php if(isset($dropdownFields['gender'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['gender']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('gender') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>

                                          <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_image" class="form-label">Applicant Image</label>
                                                <input type="file" class="form-control" id="applicant_image" name="applicant_image">
                                            </div>
                                        </div>

                                    </div>

                                    <!-- Contact Information -->
                                    <h4 class="mt-4">Contact Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="contact_number" class="form-label">Contact Number <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="contact_number"
                                                    name="contact_number" value="<?php echo e(old('contact_number')); ?>">
                                                <?php $__errorArgs = ['contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="contact_verified" class="form-label">Contact Verified</label>
                                                <select class="form-select" id="contact_verified"
                                                    name="contact_verified">
                                                    <option value="0"
                                                        <?php echo e(old('contact_verified') == '0' ? 'selected' : ''); ?>>No</option>
                                                    <option value="1"
                                                        <?php echo e(old('contact_verified') == '1' ? 'selected' : ''); ?>>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="email" class="form-label">Email</label>
                                                <input type="email" class="form-control" id="email" name="email"
                                                    value="<?php echo e(old('email')); ?>">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="address_type" class="form-label">Address Type</label>
                                                <select class="form-select" id="address_type" name="address_type">
                                                    <option value="">Select Type</option>
                                                    <?php if(isset($dropdownFields['address_type'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['address_type']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('address_type') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="current_pincode" class="form-label">Pincode <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="current_pincode"
                                                    name="current_pincode" value="<?php echo e(old('current_pincode')); ?>">
                                                <?php $__errorArgs = ['current_pincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="current_state" class="form-label">Current State</label>
                                                <select class="form-select" id="current_state" name="current_state">
                                                    <option value="">Select State</option>
                                                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($state->id); ?>"
                                                            <?php echo e(old('current_state') == $state->id ? 'selected' : ''); ?>>
                                                            <?php echo e($state->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="current_city" class="form-label">Current City</label>
                                                <select class="form-select" id="current_city" name="current_city">
                                                    <option value="">Select City</option>
                                                    <?php if(old('current_city')): ?>
                                                        <?php $__currentLoopData = $cities->where('state_id', old('current_state')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($city->id); ?>"
                                                                <?php echo e(old('current_city') == $city->id ? 'selected' : ''); ?>>
                                                                <?php echo e($city->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="current_address" class="form-label">Current Address <span
                                                        class="text-danger"></span></label>
                                                <textarea class="form-control" id="current_address" name="current_address" rows="1"><?php echo e(old('current_address')); ?></textarea>
                                                <?php $__errorArgs = ['current_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="place_of_birth" class="form-label">Place of Birth <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="place_of_birth"
                                                    name="place_of_birth" value="<?php echo e(old('place_of_birth')); ?>">
                                                <?php $__errorArgs = ['place_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="nationality" class="form-label">Nationality</label>
                                                <select class="form-select" id="nationality" name="nationality">
                                                    <option value="">Select Nationality</option>
                                                    <?php if(isset($dropdownFields['nationality'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['nationality']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('nationality') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>

                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="marital_status" class="form-label">Marital Status</label>
                                                <select class="form-select" id="marital_status" name="marital_status">
                                                    <option value="">Select Status</option>
                                                    <?php if(isset($dropdownFields['marital_status'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['marital_status']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('marital_status') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="spouse_name" class="form-label">Spouse Name</label>
                                                <input type="text" class="form-control" id="spouse_name"
                                                    name="spouse_name" value="<?php echo e(old('spouse_name')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Identity Documents -->
                                    <h4 class="mt-4">Identity Documents</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="pan" class="form-label">PAN</label>
                                                <input type="text" class="form-control" id="pan" name="pan"
                                                    value="<?php echo e(old('pan')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="pan_verified" class="form-label">PAN Verified</label>
                                                <select class="form-select" id="pan_verified" name="pan_verified">
                                                    <option value="0"
                                                        <?php echo e(old('pan_verified') == '0' ? 'selected' : ''); ?>>No</option>
                                                    <option value="1"
                                                        <?php echo e(old('pan_verified') == '1' ? 'selected' : ''); ?>>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="aadhaar" class="form-label">Aadhaar</label>
                                                <input type="text" class="form-control" id="aadhaar" name="aadhaar"
                                                    value="<?php echo e(old('aadhaar')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="aadhaar_verified" class="form-label">Aadhaar Verified</label>
                                                <select class="form-select" id="aadhaar_verified"
                                                    name="aadhaar_verified">
                                                    <option value="0"
                                                        <?php echo e(old('aadhaar_verified') == '0' ? 'selected' : ''); ?>>No</option>
                                                    <option value="1"
                                                        <?php echo e(old('aadhaar_verified') == '1' ? 'selected' : ''); ?>>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="form_60" class="form-label">Form 60</label>
                                                <select class="form-select" id="form_60" name="form_60">
                                                    <option value="0" <?php echo e(old('form_60') == '0' ? 'selected' : ''); ?>>
                                                        No</option>
                                                    <option value="1" <?php echo e(old('form_60') == '1' ? 'selected' : ''); ?>>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="voter_id" class="form-label">Voter ID</label>
                                                <input type="text" class="form-control" id="voter_id"
                                                    name="voter_id" value="<?php echo e(old('voter_id')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="voter_id_verified" class="form-label">Voter ID
                                                    Verified</label>
                                                <select class="form-select" id="voter_id_verified"
                                                    name="voter_id_verified">
                                                    <option value="0"
                                                        <?php echo e(old('voter_id_verified') == '0' ? 'selected' : ''); ?>>No</option>
                                                    <option value="1"
                                                        <?php echo e(old('voter_id_verified') == '1' ? 'selected' : ''); ?>>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="driving_license" class="form-label">Driving License</label>
                                                <input type="text" class="form-control" id="driving_license"
                                                    name="driving_license" value="<?php echo e(old('driving_license')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="driving_license_verified" class="form-label">DL
                                                    Verified</label>
                                                <select class="form-select" id="driving_license_verified"
                                                    name="driving_license_verified">
                                                    <option value="0"
                                                        <?php echo e(old('driving_license_verified') == '0' ? 'selected' : ''); ?>>No
                                                    </option>
                                                    <option value="1"
                                                        <?php echo e(old('driving_license_verified') == '1' ? 'selected' : ''); ?>>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="passport" class="form-label">Passport</label>
                                                <input type="text" class="form-control" id="passport"
                                                    name="passport" value="<?php echo e(old('passport')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Banking and References -->
                                    <h4 class="mt-4">Banking & References</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="banking_info_id" class="form-label">Banking Info</label>
                                                <select class="form-select" id="banking_info" name="banking_info">
                                                    <option value="">Select Status</option>
                                                    <?php if(isset($dropdownFields['banking_info'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['banking_info']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('banking_info') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="mb-3">
                                                <label class="form-label">References</label>
                                                <button type="button" class="btn btn-sm btn-primary float-end"
                                                    id="addReference">Add More</button>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="referencesContainer">
                                        <?php
                                            $referenceCount = 0;
                                            foreach (old() as $key => $value) {
                                                if (
                                                    str_starts_with($key, 'reference_') &&
                                                    !str_contains($key, '_relation_id') &&
                                                    !str_contains($key, '_contact_no') &&
                                                    !empty($value)
                                                ) {
                                                    $referenceCount++;
                                                }
                                            }
                                            $referenceCount = max(1, $referenceCount);
                                        ?>

                                        <?php for($i = 1; $i <= $referenceCount; $i++): ?>
                                            <div class="row reference-row">
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="reference_<?php echo e($i); ?>"
                                                            class="form-label">Reference Name</label>
                                                        <input type="text" class="form-control"
                                                            id="reference_<?php echo e($i); ?>"
                                                            name="reference_<?php echo e($i); ?>"
                                                            value="<?php echo e(old('reference_' . $i)); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="reference_<?php echo e($i); ?>_contact_no"
                                                            class="form-label">Reference Contact No</label>
                                                        <input type="text" class="form-control"
                                                            id="reference_<?php echo e($i); ?>_contact_no"
                                                            name="reference_<?php echo e($i); ?>_contact_no"
                                                            value="<?php echo e(old('reference_' . $i . '_contact_no')); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="reference_<?php echo e($i); ?>_relation_id"
                                                            class="form-label">Reference
                                                            Relation</label>
                                                        <select class="form-select"
                                                            id="reference_<?php echo e($i); ?>_relation_id"
                                                            name="reference_<?php echo e($i); ?>_relation_id">
                                                            <option value="">Select Relation</option>
                                                            <?php if(isset($dropdownFields['relation_with_applicant'])): ?>
                                                                <?php $__currentLoopData = $dropdownFields['relation_with_applicant']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($option->id); ?>"
                                                                        <?php echo e(old('reference_' . $i . '_relation_id') == $option->id ? 'selected' : ''); ?>>
                                                                        <?php echo e($option->option_value); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">&nbsp;</label>
                                                        <button type="button"
                                                            class="btn btn-danger btn-sm d-block removeReference"
                                                            style="<?php echo e($i == 1 ? 'display:none;' : ''); ?>">Remove</button>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endfor; ?>
                                    </div>

                                    <!-- Loan Information -->
                                    <h4 class="mt-4">Loan Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="login_date" class="form-label">Login Date</label>
                                                <input type="date" class="form-control" id="login_date"
                                                    name="login_date" value="<?php echo e(old('login_date')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="login_amount" class="form-label">Login Amount</label>
                                                <input type="number" step="0.01" class="form-control"
                                                    id="login_amount" name="login_amount"
                                                    value="<?php echo e(old('login_amount')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="tenure_id" class="form-label">Tenure</label>
                                                <select class="form-select" id="tenure" name="tenure">
                                                    <option value="">Select Tenure</option>
                                                    <?php if(isset($dropdownFields['tenure'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['tenure']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('tenure') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="roi" class="form-label">ROI</label>
                                                <input type="number" step="0.01" class="form-control" id="roi"
                                                    name="roi" value="<?php echo e(old('roi')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="branch_id" class="form-label">Branch</label>
                                                <select class="form-select" id="branch_id" name="branch_id">
                                                    <option value="">Select Branch</option>
                                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(Auth::user()->role_id != 1): ?>
                                                            <?php if(Auth::user()->branch_id == $branch->id): ?>
                                                                <option value="<?php echo e($branch->id); ?>">
                                                                    <?php echo e($branch->branch_name); ?>

                                                                </option>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <option value="<?php echo e($branch->id); ?>"
                                                                <?php echo e(old('branch_id') == $branch->id ? 'selected' : ''); ?>>
                                                                <?php echo e($branch->branch_name); ?>

                                                            </option>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="bm_name_id" class="form-label">BM Name</label>
                                                <select class="form-select" id="bm_name_id" name="bm_name_id">
                                                    <option value="">Select BM</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="rm_name" class="form-label">RM Name</label>
                                                <input type="text" class="form-control" id="rm_name" name="rm_name"
                                                    value="<?php echo e(old('rm_name')); ?>">
                                            </div>
                                        </div>


                                    </div>


                                    <!-- BT/IMD Information -->
                                    <h4 class="mt-4">BT/IMD Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="bt_yes_no_id" class="form-label">BT (Yes/No)</label>
                                                <select class="form-select" id="bt_yes_no_id" name="bt_yes_no_id">
                                                    <option value="">Select Option</option>
                                                    <option value="0"
                                                        <?php echo e(old('bt_yes_no_id') == '0' ? 'selected' : ''); ?>>No</option>
                                                    <option value="1"
                                                        <?php echo e(old('bt_yes_no_id') == '1' ? 'selected' : ''); ?>>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="bt_company_name" class="form-label">BT Company Name</label>
                                                <input type="text" class="form-control" id="bt_company_name"
                                                    name="bt_company_name" value="<?php echo e(old('bt_company_name')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="imd_waiver" class="form-label">IMD Waiver</label>
                                                <select class="form-select" id="imd_waiver" name="imd_waiver">
                                                    <option value="">Select Option</option>
                                                    <?php if(isset($dropdownFields['imd_waiver'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['imd_waiver']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('imd_waiver') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="imd_transaction_ref" class="form-label">IMD Transaction
                                                    Ref</label>
                                                <input type="text" class="form-control" id="imd_transaction_ref"
                                                    name="imd_transaction_ref" value="<?php echo e(old('imd_transaction_ref')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Business Information -->
                                    <h4 class="mt-4">Business Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="business_address" class="form-label">Business Address</label>
                                                <textarea class="form-control" id="business_address" name="business_address" rows="1"><?php echo e(old('business_address')); ?></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="annual_income" class="form-label">Annual Income</label>
                                                <input type="number" step="0.01" class="form-control"
                                                    id="annual_income" name="annual_income"
                                                    value="<?php echo e(old('annual_income')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="obligation" class="form-label">Obligation</label>
                                                <input type="number" step="0.01" class="form-control"
                                                    id="obligation" name="obligation" value="<?php echo e(old('obligation')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="foir" class="form-label">FOIR</label>
                                                <input type="number" step="0.01" class="form-control" id="foir"
                                                    name="foir" value="<?php echo e(old('foir')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="ltv" class="form-label">LTV</label>
                                                <input type="number" step="0.01" class="form-control" id="ltv"
                                                    name="ltv" value="<?php echo e(old('ltv')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="gps_tagging" class="form-label">GPS Tagging <span
                                                        id="gpsSync"
                                                        style="font-size: 14px; cursor: pointer;">🔄</span></label>
                                                <input type="text" class="form-control" id="gps_tagging"
                                                    name="gps_tagging" value="<?php echo e(old('gps_tagging')); ?>">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="property_type" class="form-label">Property Type</label>
                                                <select class="form-select" id="property_type" name="property_type">
                                                    <option value="">Select Type</option>
                                                    <?php if(isset($dropdownFields['property_type'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['property_type']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('property_type') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="property_owner_name" class="form-label">Property Owner
                                                    Name</label>
                                                <input type="text" class="form-control" id="property_owner_name"
                                                    name="property_owner_name" value="<?php echo e(old('property_owner_name')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="property_address" class="form-label">Property Address</label>
                                                <textarea class="form-control" id="property_address" name="property_address" rows="1"><?php echo e(old('property_address')); ?></textarea>
                                            </div>
                                        </div>

                                    </div>


                                    <!-- PSL Information -->
                                    <h4 class="mt-4">PSL Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="psl_yes_no_id" class="form-label">PSL (Yes/No)</label>
                                                <select class="form-select" id="psl_yes_no_id" name="psl_yes_no_id">
                                                    <option value="">Select Option</option>
                                                    <option value="0"
                                                        <?php echo e(old('psl_yes_no_id') == '0' ? 'selected' : ''); ?>>No</option>
                                                    <option value="1"
                                                        <?php echo e(old('psl_yes_no_id') == '1' ? 'selected' : ''); ?>>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="manufacturing_service_agriculture"
                                                    class="form-label">Manufacturing/Service/Agriculture</label>
                                                <select class="form-select" id="manufacturing_service_agriculture"
                                                    name="manufacturing_service_agriculture">
                                                    <option value="">Select Status</option>
                                                    <?php if(isset($dropdownFields['manufacturing_service_agriculture'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['manufacturing_service_agriculture']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('manufacturing_service_agriculture') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="psl_sub_category" class="form-label">PSL Sub Category</label>
                                                <select class="form-select" id="psl_sub_category"
                                                    name="psl_sub_category">
                                                    <option value="">Select Category</option>
                                                    <?php if(isset($dropdownFields['psl_sub_category'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['psl_sub_category']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('psl_sub_category') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="purpose_of_loans" class="form-label">Purpose of Loans</label>
                                                <select class="form-select" id="purpose_of_loans"
                                                    name="purpose_of_loans">
                                                    <option value="">Select Purpose</option>
                                                    <?php if(isset($dropdownFields['purpose_of_loans'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['purpose_of_loans']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('purpose_of_loans') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="psl_document_type" class="form-label">PSL Document
                                                    Type</label>
                                                <select class="form-select" id="psl_document_type"
                                                    name="psl_document_type">
                                                    <option value="">Select Type</option>
                                                    <?php if(isset($dropdownFields['psl_document_type'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['psl_document_type']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('psl_document_type') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="psl_document_number" class="form-label">PSL Document
                                                    Number</label>
                                                <input type="text" class="form-control" id="psl_document_number"
                                                    name="psl_document_number" value="<?php echo e(old('psl_document_number')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="field_investigation_flag" class="form-label">Field
                                                    Investigation
                                                    Flag</label>
                                                <select class="form-select" id="field_investigation_flag"
                                                    name="field_investigation_flag">
                                                    <option value="0"
                                                        <?php echo e(old('field_investigation_flag') == '0' ? 'selected' : ''); ?>>No
                                                    </option>
                                                    <option value="1"
                                                        <?php echo e(old('field_investigation_flag') == '1' ? 'selected' : ''); ?>>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="tele_verification_flag" class="form-label">Tele Verification
                                                    Flag</label>
                                                <select class="form-select" id="tele_verification_flag"
                                                    name="tele_verification_flag">
                                                    <option value="0"
                                                        <?php echo e(old('tele_verification_flag') == '0' ? 'selected' : ''); ?>>No
                                                    </option>
                                                    <option value="1"
                                                        <?php echo e(old('tele_verification_flag') == '1' ? 'selected' : ''); ?>>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="personal_discussion_flag" class="form-label">Personal
                                                    Discussion
                                                    Flag</label>
                                                <select class="form-select" id="personal_discussion_flag"
                                                    name="personal_discussion_flag">
                                                    <option value="0"
                                                        <?php echo e(old('personal_discussion_flag') == '0' ? 'selected' : ''); ?>>No
                                                    </option>
                                                    <option value="1"
                                                        <?php echo e(old('personal_discussion_flag') == '1' ? 'selected' : ''); ?>>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>



                                    <!-- System Fields -->
                                    <h4 class="mt-4">Defaults</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="status" class="form-label">Lead Status</label>
                                                <select class="form-select" id="" name="status">
                                                    <option value="1" <?php echo e(old('status') == '1' ? 'selected' : ''); ?>>
                                                        New</option>
                                                    <option value="2" <?php echo e(old('status') == '2' ? 'selected' : ''); ?>>
                                                        RO Assigned</option>
                                                    <option value="3" <?php echo e(old('status') == '3' ? 'selected' : ''); ?>>
                                                        RO Verified</option>
                                                    <option value="4" <?php echo e(old('status') == '4' ? 'selected' : ''); ?>>
                                                        Branch Review</option>
                                                        <option value="5" <?php echo e(old('status') == '5' ? 'selected' : ''); ?>>
                                                        Branch Approved</option>
                                                    <option value="6" <?php echo e(old('status') == '6' ? 'selected' : ''); ?>>
                                                        Bank wise approve</option>
                                                    <option value="7" <?php echo e(old('status') == '7' ? 'selected' : ''); ?>>
                                                        Final Lead source</option>
                                                    <option value="90" <?php echo e(old('status') == '90' ? 'selected' : ''); ?>>
                                                        Cancelled</option>
                                                    <option value="91" <?php echo e(old('status') == '91' ? 'selected' : ''); ?>>
                                                        Other</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="assign_to" class="form-label">Lead Assign To</label>
                                                <select class="form-select" id="assign_to" name="assign_to">
                                                    <option value="">Select User</option>
                                                    
                                                </select>
                                            </div>
                                        </div>

                                    </div>
                                </section>













                                <!--CO Applicant Basic Information -->
                                <h1 class="mt-5">CO Applicant Details <button type="button"
                                        class="btn btn-primary btn-sm ms-3" id="toggleCoApplicant">Add
                                        Co-Applicant</button> <button type="button" class="btn btn-success btn-sm ms-2"
                                        id="addMoreCoApplicant" style="display: none;">Add More</button></h1>
                                <section id="co_applicant_section"
                                    style="display: none; border-bottom: 2px dashed #7c7f90; padding-bottom: 50px;">
                                    <h4 class="mt-3">Basic Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_first_name" class="form-label">First Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="co_applicant_first_name"
                                                    name="co_applicant_first_name"
                                                    value="<?php echo e(old('co_applicant_first_name')); ?>">
                                                <?php $__errorArgs = ['co_applicant_first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_middle_name" class="form-label">Middle
                                                    Name</label>
                                                <input type="text" class="form-control" id="co_applicant_middle_name"
                                                    name="co_applicant_middle_name"
                                                    value="<?php echo e(old('co_applicant_middle_name')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_last_name" class="form-label">Last Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="co_applicant_last_name"
                                                    name="co_applicant_last_name"
                                                    value="<?php echo e(old('co_applicant_last_name')); ?>">
                                                <?php $__errorArgs = ['co_applicant_last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_father_name" class="form-label">Father Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="co_applicant_father_name"
                                                    name="co_applicant_father_name"
                                                    value="<?php echo e(old('co_applicant_father_name')); ?>">
                                                <?php $__errorArgs = ['co_applicant_father_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_caste" class="form-label">Caste</label>
                                                <select class="form-select" id="co_applicant_caste"
                                                    name="co_applicant_caste">
                                                    <option value="">Select Caste</option>
                                                    <?php if(isset($dropdownFields['caste'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['caste']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('co_applicant_caste') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_dob" class="form-label">DOB</label>
                                                <input type="date" class="form-control" id="co_applicant_dob"
                                                    name="co_applicant_dob" value="<?php echo e(old('co_applicant_dob')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_age" class="form-label">Age</label>
                                                <input type="number" class="form-control" id="co_applicant_age"
                                                    name="co_applicant_age" value="<?php echo e(old('co_applicant_age')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_gender" class="form-label">Gender</label>
                                                <select class="form-select" id="co_applicant_gender"
                                                    name="co_applicant_gender">
                                                    <option value="">Select Gender</option>
                                                    <?php if(isset($dropdownFields['gender'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['gender']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('co_applicant_gender') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>

  <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_image" class="form-label">Co Applicant Image</label>
                                                <input type="file" class="form-control" id="co_applicant_image"
                                                    name="co_applicant_image"  accept="image/*">
                                            </div>
                                        </div>

                                    </div>

                                    <!-- Contact Information -->
                                    <h4 class="mt-4">Contact Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_contact_number" class="form-label">Contact Number
                                                    <span class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="co_applicant_contact_number" name="co_applicant_contact_number"
                                                    value="<?php echo e(old('co_applicant_contact_number')); ?>">
                                                <?php $__errorArgs = ['co_applicant_contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_contact_verified" class="form-label">Contact
                                                    Verified</label>
                                                <select class="form-select" id="co_applicant_contact_verified"
                                                    name="co_applicant_contact_verified">
                                                    <option value="0"
                                                        <?php echo e(old('co_applicant_contact_verified') == '0' ? 'selected' : ''); ?>>
                                                        No</option>
                                                    <option value="1"
                                                        <?php echo e(old('co_applicant_contact_verified') == '1' ? 'selected' : ''); ?>>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_email" class="form-label">Email</label>
                                                <input type="email" class="form-control" id="co_applicant_email"
                                                    name="co_applicant_email" value="<?php echo e(old('co_applicant_email')); ?>">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_address_type" class="form-label">Address
                                                    Type</label>
                                                <select class="form-select" id="co_applicant_address_type"
                                                    name="co_applicant_address_type">
                                                    <option value="">Select Type</option>
                                                    <?php if(isset($dropdownFields['address_type'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['address_type']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('co_applicant_address_type') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_current_pincode" class="form-label">Pincode <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="co_applicant_current_pincode" name="co_applicant_current_pincode"
                                                    value="<?php echo e(old('co_applicant_current_pincode')); ?>">
                                                <?php $__errorArgs = ['co_applicant_current_pincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_current_state" class="form-label">Current
                                                    State</label>
                                                <select class="form-control co-applicant-state-select"
                                                    id="co_applicant_current_state" name="co_applicant_current_state"
                                                    data-target="co_applicant_current_city">
                                                    <option value="">Select State</option>
                                                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($state->id); ?>"
                                                            <?php echo e(old('co_applicant_current_state') == $state->id ? 'selected' : ''); ?>>
                                                            <?php echo e($state->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_current_city" class="form-label">Current
                                                    City</label>
                                                <select class="form-control co-applicant-city-select"
                                                    id="co_applicant_current_city" name="co_applicant_current_city">
                                                    <option value="">Select City</option>
                                                    <?php if(old('co_applicant_current_state')): ?>
                                                        <?php $__currentLoopData = $cities->where('state_id', old('co_applicant_current_state')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($city->id); ?>"
                                                                <?php echo e(old('co_applicant_current_city') == $city->id ? 'selected' : ''); ?>>
                                                                <?php echo e($city->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_current_address" class="form-label">Current
                                                    Address <span class="text-danger"></span></label>
                                                <textarea class="form-control" id="co_applicant_current_address" name="co_applicant_current_address" rows="1"><?php echo e(old('co_applicant_current_address')); ?></textarea>
                                                <?php $__errorArgs = ['co_applicant_current_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_place_of_birth" class="form-label">Place of Birth
                                                    <span class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="co_applicant_place_of_birth" name="co_applicant_place_of_birth"
                                                    value="<?php echo e(old('co_applicant_place_of_birth')); ?>">
                                                <?php $__errorArgs = ['co_applicant_place_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_nationality"
                                                    class="form-label">Nationality</label>
                                                <select class="form-select" id="co_applicant_nationality"
                                                    name="co_applicant_nationality">
                                                    <option value="">Select Nationality</option>
                                                    <?php if(isset($dropdownFields['nationality'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['nationality']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('co_applicant_nationality') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_marital_status" class="form-label">Marital
                                                    Status</label>
                                                <select class="form-select" id="co_applicant_marital_status"
                                                    name="co_applicant_marital_status">
                                                    <option value="">Select Status</option>
                                                    <?php if(isset($dropdownFields['marital_status'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['marital_status']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('co_applicant_marital_status') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_spouse_name" class="form-label">Spouse
                                                    Name</label>
                                                <input type="text" class="form-control" id="co_applicant_spouse_name"
                                                    name="co_applicant_spouse_name"
                                                    value="<?php echo e(old('co_applicant_spouse_name')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Identity Documents -->
                                    <h4 class="mt-4">Identity Documents</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_pan" class="form-label">PAN</label>
                                                <input type="text" class="form-control" id="co_applicant_pan"
                                                    name="co_applicant_pan" value="<?php echo e(old('co_applicant_pan')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_pan_verified" class="form-label">PAN
                                                    Verified</label>
                                                <select class="form-select" id="co_applicant_pan_verified"
                                                    name="co_applicant_pan_verified">
                                                    <option value="0"
                                                        <?php echo e(old('co_applicant_pan_verified') == '0' ? 'selected' : ''); ?>>No
                                                    </option>
                                                    <option value="1"
                                                        <?php echo e(old('co_applicant_pan_verified') == '1' ? 'selected' : ''); ?>>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_aadhaar" class="form-label">Aadhaar</label>
                                                <input type="text" class="form-control" id="co_applicant_aadhaar"
                                                    name="co_applicant_aadhaar"
                                                    value="<?php echo e(old('co_applicant_aadhaar')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_aadhaar_verified" class="form-label">Aadhaar
                                                    Verified</label>
                                                <select class="form-select" id="co_applicant_aadhaar_verified"
                                                    name="co_applicant_aadhaar_verified">
                                                    <option value="0"
                                                        <?php echo e(old('co_applicant_aadhaar_verified') == '0' ? 'selected' : ''); ?>>
                                                        No</option>
                                                    <option value="1"
                                                        <?php echo e(old('co_applicant_aadhaar_verified') == '1' ? 'selected' : ''); ?>>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_form_60" class="form-label">Form 60</label>
                                                <select class="form-select" id="co_applicant_form_60"
                                                    name="co_applicant_form_60">
                                                    <option value="0"
                                                        <?php echo e(old('co_applicant_form_60') == '0' ? 'selected' : ''); ?>>No
                                                    </option>
                                                    <option value="1"
                                                        <?php echo e(old('co_applicant_form_60') == '1' ? 'selected' : ''); ?>>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_voter_id" class="form-label">Voter ID</label>
                                                <input type="text" class="form-control" id="co_applicant_voter_id"
                                                    name="co_applicant_voter_id"
                                                    value="<?php echo e(old('co_applicant_voter_id')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_voter_id_verified" class="form-label">Voter ID
                                                    Verified</label>
                                                <select class="form-select" id="co_applicant_voter_id_verified"
                                                    name="co_applicant_voter_id_verified">
                                                    <option value="0"
                                                        <?php echo e(old('co_applicant_voter_id_verified') == '0' ? 'selected' : ''); ?>>
                                                        No</option>
                                                    <option value="1"
                                                        <?php echo e(old('co_applicant_voter_id_verified') == '1' ? 'selected' : ''); ?>>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_driving_license" class="form-label">Driving
                                                    License</label>
                                                <input type="text" class="form-control"
                                                    id="co_applicant_driving_license" name="co_applicant_driving_license"
                                                    value="<?php echo e(old('co_applicant_driving_license')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_driving_license_verified" class="form-label">DL
                                                    Verified</label>
                                                <select class="form-select" id="co_applicant_driving_license_verified"
                                                    name="co_applicant_driving_license_verified">
                                                    <option value="0"
                                                        <?php echo e(old('co_applicant_driving_license_verified') == '0' ? 'selected' : ''); ?>>
                                                        No</option>
                                                    <option value="1"
                                                        <?php echo e(old('co_applicant_driving_license_verified') == '1' ? 'selected' : ''); ?>>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_passport" class="form-label">Passport</label>
                                                <input type="text" class="form-control" id="co_applicant_passport"
                                                    name="co_applicant_passport"
                                                    value="<?php echo e(old('co_applicant_passport')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div id="additionalCoApplicants">
                                        <?php
                                            $coApplicantCount = 1;
                                            // Check for additional co-applicants in old data
                                            while (old('co_applicant_' . ($coApplicantCount + 1) . '_first_name')) {
                                                $coApplicantCount++;
                                            }
                                        ?>

                                        <?php for($i = 2; $i <= $coApplicantCount; $i++): ?>
                                            <div class="additional-co-applicant">
                                                <hr class="my-4">
                                                <h4 class="mt-4">Co-Applicant <?php echo e($i); ?> <button
                                                        type="button"
                                                        class="btn btn-danger btn-sm ms-2 removeCoApplicant">Remove</button>
                                                </h4>
                                                <h5 class="mt-3">Basic Information</h5>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">First
                                                                Name</label><input type="text" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_first_name"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_first_name')); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Middle
                                                                Name</label><input type="text" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_middle_name"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_middle_name')); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Last
                                                                Name</label><input type="text" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_last_name"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_last_name')); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Father
                                                                Name</label><input type="text" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_father_name"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_father_name')); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Caste</label><select
                                                                class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_caste">
                                                                <option value="">Select Caste</option>
                                                                <?php if(isset($dropdownFields['caste'])): ?>
                                                                    <?php $__currentLoopData = $dropdownFields['caste']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($option->id); ?>"
                                                                            <?php echo e(old('co_applicant_' . $i . '_caste') == $option->id ? 'selected' : ''); ?>>
                                                                            <?php echo e($option->option_value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">DOB</label><input
                                                                type="date" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_dob"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_dob')); ?>"></div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Age</label><input
                                                                type="number" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_age"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_age')); ?>"></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Gender</label><select
                                                                class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_gender">
                                                                <option value="">Select Gender</option>
                                                                <?php if(isset($dropdownFields['gender'])): ?>
                                                                    <?php $__currentLoopData = $dropdownFields['gender']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($option->id); ?>"
                                                                            <?php echo e(old('co_applicant_' . $i . '_gender') == $option->id ? 'selected' : ''); ?>>
                                                                            <?php echo e($option->option_value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <h5 class="mt-4">Contact Information</h5>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Contact
                                                                Number</label><input type="text" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_contact_number"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_contact_number')); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Contact
                                                                Verified</label><select class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_contact_verified">
                                                                <option value="0"
                                                                    <?php echo e(old('co_applicant_' . $i . '_contact_verified') == '0' ? 'selected' : ''); ?>>
                                                                    No</option>
                                                                <option value="1"
                                                                    <?php echo e(old('co_applicant_' . $i . '_contact_verified') == '1' ? 'selected' : ''); ?>>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Email</label><input type="email"
                                                                class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_email"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_email')); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Address
                                                                Type</label><select class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_address_type">
                                                                <option value="">Select Type</option>
                                                                <?php if(isset($dropdownFields['address_type'])): ?>
                                                                    <?php $__currentLoopData = $dropdownFields['address_type']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($option->id); ?>"
                                                                            <?php echo e(old('co_applicant_' . $i . '_address_type') == $option->id ? 'selected' : ''); ?>>
                                                                            <?php echo e($option->option_value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Pincode</label><input type="text"
                                                                class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_current_pincode"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_current_pincode')); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Current
                                                                State</label><select
                                                                class="form-control co-applicant-state-select"
                                                                name="co_applicant_<?php echo e($i); ?>_current_state"
                                                                data-target="co_applicant_<?php echo e($i); ?>_current_city">
                                                                <option value="">Select State</option>
                                                                <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($state->id); ?>"
                                                                        <?php echo e(old('co_applicant_' . $i . '_current_state') == $state->id ? 'selected' : ''); ?>>
                                                                        <?php echo e($state->name); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Current
                                                                City</label><select
                                                                class="form-control co-applicant-city-select"
                                                                name="co_applicant_<?php echo e($i); ?>_current_city"
                                                                id="co_applicant_<?php echo e($i); ?>_current_city">
                                                                <option value="">Select City</option>
                                                                <?php if(old('co_applicant_' . $i . '_current_state')): ?>
                                                                    <?php $__currentLoopData = $cities->where('state_id', old('co_applicant_' . $i . '_current_state')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($city->id); ?>"
                                                                            <?php echo e(old('co_applicant_' . $i . '_current_city') == $city->id ? 'selected' : ''); ?>>
                                                                            <?php echo e($city->name); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Current
                                                                Address</label>
                                                            <textarea class="form-control" name="co_applicant_<?php echo e($i); ?>_current_address" rows="1"><?php echo e(old('co_applicant_' . $i . '_current_address')); ?></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Place of
                                                                Birth</label><input type="text" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_place_of_birth"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_place_of_birth')); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Nationality</label><select
                                                                class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_nationality">
                                                                <option value="">Select Nationality</option>
                                                                <?php if(isset($dropdownFields['nationality'])): ?>
                                                                    <?php $__currentLoopData = $dropdownFields['nationality']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($option->id); ?>"
                                                                            <?php echo e(old('co_applicant_' . $i . '_nationality') == $option->id ? 'selected' : ''); ?>>
                                                                            <?php echo e($option->option_value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Marital
                                                                Status</label><select class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_marital_status">
                                                                <option value="">Select Status</option>
                                                                <?php if(isset($dropdownFields['marital_status'])): ?>
                                                                    <?php $__currentLoopData = $dropdownFields['marital_status']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($option->id); ?>"
                                                                            <?php echo e(old('co_applicant_' . $i . '_marital_status') == $option->id ? 'selected' : ''); ?>>
                                                                            <?php echo e($option->option_value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Spouse
                                                                Name</label><input type="text" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_spouse_name"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_spouse_name')); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <h5 class="mt-4">Identity Documents</h5>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">PAN</label><input
                                                                type="text" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_pan"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_pan')); ?>"></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">PAN
                                                                Verified</label><select class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_pan_verified">
                                                                <option value="0"
                                                                    <?php echo e(old('co_applicant_' . $i . '_pan_verified') == '0' ? 'selected' : ''); ?>>
                                                                    No</option>
                                                                <option value="1"
                                                                    <?php echo e(old('co_applicant_' . $i . '_pan_verified') == '1' ? 'selected' : ''); ?>>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Aadhaar</label><input type="text"
                                                                class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_aadhaar"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_aadhaar')); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Aadhaar
                                                                Verified</label><select class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_aadhaar_verified">
                                                                <option value="0"
                                                                    <?php echo e(old('co_applicant_' . $i . '_aadhaar_verified') == '0' ? 'selected' : ''); ?>>
                                                                    No</option>
                                                                <option value="1"
                                                                    <?php echo e(old('co_applicant_' . $i . '_aadhaar_verified') == '1' ? 'selected' : ''); ?>>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Form
                                                                60</label><select class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_form_60">
                                                                <option value="0"
                                                                    <?php echo e(old('co_applicant_' . $i . '_form_60') == '0' ? 'selected' : ''); ?>>
                                                                    No</option>
                                                                <option value="1"
                                                                    <?php echo e(old('co_applicant_' . $i . '_form_60') == '1' ? 'selected' : ''); ?>>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Voter
                                                                ID</label><input type="text" class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_voter_id"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_voter_id')); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Voter ID
                                                                Verified</label><select class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_voter_id_verified">
                                                                <option value="0"
                                                                    <?php echo e(old('co_applicant_' . $i . '_voter_id_verified') == '0' ? 'selected' : ''); ?>>
                                                                    No</option>
                                                                <option value="1"
                                                                    <?php echo e(old('co_applicant_' . $i . '_voter_id_verified') == '1' ? 'selected' : ''); ?>>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Driving
                                                                License</label><input type="text"
                                                                class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_driving_license"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_driving_license')); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">DL
                                                                Verified</label><select class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_driving_license_verified">
                                                                <option value="0"
                                                                    <?php echo e(old('co_applicant_' . $i . '_driving_license_verified') == '0' ? 'selected' : ''); ?>>
                                                                    No</option>
                                                                <option value="1"
                                                                    <?php echo e(old('co_applicant_' . $i . '_driving_license_verified') == '1' ? 'selected' : ''); ?>>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Passport</label><input type="text"
                                                                class="form-control"
                                                                name="co_applicant_<?php echo e($i); ?>_passport"
                                                                value="<?php echo e(old('co_applicant_' . $i . '_passport')); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endfor; ?>
                                    </div>
                                </section>












                                <!--Guarantor Basic Information -->
                                <h1 class="mt-5">Guarantor Details <button type="button"
                                        class="btn btn-primary btn-sm ms-3" id="toggleGuarantor">Add Guarantor</button>
                                </h1>
                                <section id="guarantor_section" style="display: none;">
                                    <h4 class="mt-3">Basic Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_first_name" class="form-label">First Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="guarantor_first_name"
                                                    name="guarantor_first_name"
                                                    value="<?php echo e(old('guarantor_first_name')); ?>">
                                                <?php $__errorArgs = ['guarantor_first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_middle_name" class="form-label">Middle
                                                    Name</label>
                                                <input type="text" class="form-control" id="guarantor_middle_name"
                                                    name="guarantor_middle_name"
                                                    value="<?php echo e(old('guarantor_middle_name')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_last_name" class="form-label">Last Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="guarantor_last_name"
                                                    name="guarantor_last_name"
                                                    value="<?php echo e(old('guarantor_last_name')); ?>">
                                                <?php $__errorArgs = ['guarantor_last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_father_name" class="form-label">Father Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="guarantor_father_name"
                                                    name="guarantor_father_name"
                                                    value="<?php echo e(old('guarantor_father_name')); ?>">
                                                <?php $__errorArgs = ['guarantor_father_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_caste" class="form-label">Caste</label>
                                                <select class="form-select" id="guarantor_caste"
                                                    name="guarantor_caste">
                                                    <option value="">Select Caste</option>
                                                    <?php if(isset($dropdownFields['caste'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['caste']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('guarantor_caste') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_dob" class="form-label">DOB</label>
                                                <input type="date" class="form-control" id="guarantor_dob"
                                                    name="guarantor_dob" value="<?php echo e(old('guarantor_dob')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_age" class="form-label">Age</label>
                                                <input type="number" class="form-control" id="guarantor_age"
                                                    name="guarantor_age" value="<?php echo e(old('guarantor_age')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_gender" class="form-label">Gender</label>
                                                <select class="form-select" id="guarantor_gender"
                                                    name="guarantor_gender">
                                                    <option value="">Select Gender</option>
                                                    <?php if(isset($dropdownFields['gender'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['gender']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('guarantor_gender') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>

 <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_image" class="form-label">Guarantor Image</label>
                                                <input type="file" class="form-control" id="guarantor_image"
                                                    name="guarantor_image" accept="image/*">
                                            </div>
                                        </div>

                                    </div>

                                    <!-- Contact Information -->
                                    <h4 class="mt-4">Contact Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_contact_number" class="form-label">Contact Number
                                                    <span class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="guarantor_contact_number" name="guarantor_contact_number"
                                                    value="<?php echo e(old('guarantor_contact_number')); ?>">
                                                <?php $__errorArgs = ['guarantor_contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_contact_verified" class="form-label">Contact
                                                    Verified</label>
                                                <select class="form-select" id="guarantor_contact_verified"
                                                    name="guarantor_contact_verified">
                                                    <option value="0"
                                                        <?php echo e(old('guarantor_contact_verified') == '0' ? 'selected' : ''); ?>>
                                                        No</option>
                                                    <option value="1"
                                                        <?php echo e(old('guarantor_contact_verified') == '1' ? 'selected' : ''); ?>>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_email" class="form-label">Email</label>
                                                <input type="email" class="form-control" id="guarantor_email"
                                                    name="guarantor_email" value="<?php echo e(old('guarantor_email')); ?>">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_address_type" class="form-label">Address
                                                    Type</label>
                                                <select class="form-select" id="guarantor_address_type"
                                                    name="guarantor_address_type">
                                                    <option value="">Select Type</option>
                                                    <?php if(isset($dropdownFields['address_type'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['address_type']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('guarantor_address_type') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_current_pincode" class="form-label">Pincode <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="guarantor_current_pincode" name="guarantor_current_pincode"
                                                    value="<?php echo e(old('guarantor_current_pincode')); ?>">
                                                <?php $__errorArgs = ['guarantor_current_pincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_current_state" class="form-label">Current
                                                    State</label>
                                                <select class="form-control guarantor-state-select"
                                                    id="guarantor_current_state" name="guarantor_current_state"
                                                    data-target="guarantor_current_city">
                                                    <option value="">Select State</option>
                                                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($state->id); ?>"
                                                            <?php echo e(old('guarantor_current_state') == $state->id ? 'selected' : ''); ?>>
                                                            <?php echo e($state->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_current_city" class="form-label">Current
                                                    City</label>
                                                <select class="form-control guarantor-city-select"
                                                    id="guarantor_current_city" name="guarantor_current_city">
                                                    <option value="">Select City</option>
                                                    <?php if(old('guarantor_current_state')): ?>
                                                        <?php $__currentLoopData = $cities->where('state_id', old('guarantor_current_state')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($city->id); ?>"
                                                                <?php echo e(old('guarantor_current_city') == $city->id ? 'selected' : ''); ?>>
                                                                <?php echo e($city->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_current_address" class="form-label">Current
                                                    Address <span class="text-danger"></span></label>
                                                <textarea class="form-control" id="guarantor_current_address" name="guarantor_current_address" rows="1"><?php echo e(old('guarantor_current_address')); ?></textarea>
                                                <?php $__errorArgs = ['guarantor_current_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_place_of_birth" class="form-label">Place of Birth
                                                    <span class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="guarantor_place_of_birth" name="guarantor_place_of_birth"
                                                    value="<?php echo e(old('guarantor_place_of_birth')); ?>">
                                                <?php $__errorArgs = ['guarantor_place_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_nationality"
                                                    class="form-label">Nationality</label>
                                                <select class="form-select" id="guarantor_nationality"
                                                    name="guarantor_nationality">
                                                    <option value="">Select Nationality</option>
                                                    <?php if(isset($dropdownFields['nationality'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['nationality']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('guarantor_nationality') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_marital_status" class="form-label">Marital
                                                    Status</label>
                                                <select class="form-select" id="guarantor_marital_status"
                                                    name="guarantor_marital_status">
                                                    <option value="">Select Status</option>
                                                    <?php if(isset($dropdownFields['marital_status'])): ?>
                                                        <?php $__currentLoopData = $dropdownFields['marital_status']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($option->id); ?>"
                                                                <?php echo e(old('guarantor_marital_status') == $option->id ? 'selected' : ''); ?>>
                                                                <?php echo e($option->option_value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_spouse_name" class="form-label">Spouse
                                                    Name</label>
                                                <input type="text" class="form-control" id="guarantor_spouse_name"
                                                    name="guarantor_spouse_name"
                                                    value="<?php echo e(old('guarantor_spouse_name')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Identity Documents -->
                                    <h4 class="mt-4">Identity Documents</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_pan" class="form-label">PAN</label>
                                                <input type="text" class="form-control" id="guarantor_pan"
                                                    name="guarantor_pan" value="<?php echo e(old('guarantor_pan')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_pan_verified" class="form-label">PAN
                                                    Verified</label>
                                                <select class="form-select" id="guarantor_pan_verified"
                                                    name="guarantor_pan_verified">
                                                    <option value="0"
                                                        <?php echo e(old('guarantor_pan_verified') == '0' ? 'selected' : ''); ?>>No
                                                    </option>
                                                    <option value="1"
                                                        <?php echo e(old('guarantor_pan_verified') == '1' ? 'selected' : ''); ?>>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_aadhaar" class="form-label">Aadhaar</label>
                                                <input type="text" class="form-control" id="guarantor_aadhaar"
                                                    name="guarantor_aadhaar" value="<?php echo e(old('guarantor_aadhaar')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_aadhaar_verified" class="form-label">Aadhaar
                                                    Verified</label>
                                                <select class="form-select" id="guarantor_aadhaar_verified"
                                                    name="guarantor_aadhaar_verified">
                                                    <option value="0"
                                                        <?php echo e(old('guarantor_aadhaar_verified') == '0' ? 'selected' : ''); ?>>
                                                        No</option>
                                                    <option value="1"
                                                        <?php echo e(old('guarantor_aadhaar_verified') == '1' ? 'selected' : ''); ?>>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_form_60" class="form-label">Form 60</label>
                                                <select class="form-select" id="guarantor_form_60"
                                                    name="guarantor_form_60">
                                                    <option value="0"
                                                        <?php echo e(old('guarantor_form_60') == '0' ? 'selected' : ''); ?>>No
                                                    </option>
                                                    <option value="1"
                                                        <?php echo e(old('guarantor_form_60') == '1' ? 'selected' : ''); ?>>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_voter_id" class="form-label">Voter ID</label>
                                                <input type="text" class="form-control" id="guarantor_voter_id"
                                                    name="guarantor_voter_id" value="<?php echo e(old('guarantor_voter_id')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_voter_id_verified" class="form-label">Voter ID
                                                    Verified</label>
                                                <select class="form-select" id="guarantor_voter_id_verified"
                                                    name="guarantor_voter_id_verified">
                                                    <option value="0"
                                                        <?php echo e(old('guarantor_voter_id_verified') == '0' ? 'selected' : ''); ?>>
                                                        No</option>
                                                    <option value="1"
                                                        <?php echo e(old('guarantor_voter_id_verified') == '1' ? 'selected' : ''); ?>>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_driving_license" class="form-label">Driving
                                                    License</label>
                                                <input type="text" class="form-control"
                                                    id="guarantor_driving_license" name="guarantor_driving_license"
                                                    value="<?php echo e(old('guarantor_driving_license')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_driving_license_verified" class="form-label">DL
                                                    Verified</label>
                                                <select class="form-select" id="guarantor_driving_license_verified"
                                                    name="guarantor_driving_license_verified">
                                                    <option value="0"
                                                        <?php echo e(old('guarantor_driving_license_verified') == '0' ? 'selected' : ''); ?>>
                                                        No</option>
                                                    <option value="1"
                                                        <?php echo e(old('guarantor_driving_license_verified') == '1' ? 'selected' : ''); ?>>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_passport" class="form-label">Passport</label>
                                                <input type="text" class="form-control" id="guarantor_passport"
                                                    name="guarantor_passport" value="<?php echo e(old('guarantor_passport')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </section>










                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Create Lead</button>
                                        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary">Cancel</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Pass data to JavaScript
        window.usersData = <?php echo json_encode($users, 15, 512) ?>;
        window.relationOptions = `
            <?php if(isset($dropdownFields['relation_with_applicant'])): ?>
                <?php $__currentLoopData = $dropdownFields['relation_with_applicant']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($option->id); ?>"><?php echo e($option->option_value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        `;
        window.stateOptions = `
            <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        `;
        window.casteOptions = `
            <?php if(isset($dropdownFields['caste'])): ?>
                <?php $__currentLoopData = $dropdownFields['caste']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($option->id); ?>"><?php echo e($option->option_value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        `;
        window.genderOptions = `
            <?php if(isset($dropdownFields['gender'])): ?>
                <?php $__currentLoopData = $dropdownFields['gender']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($option->id); ?>"><?php echo e($option->option_value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        `;
        window.addressTypeOptions = `
            <?php if(isset($dropdownFields['address_type'])): ?>
                <?php $__currentLoopData = $dropdownFields['address_type']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($option->id); ?>"><?php echo e($option->option_value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        `;
        window.nationalityOptions = `
            <?php if(isset($dropdownFields['nationality'])): ?>
                <?php $__currentLoopData = $dropdownFields['nationality']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($option->id); ?>"><?php echo e($option->option_value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        `;
        window.maritalStatusOptions = `
            <?php if(isset($dropdownFields['marital_status'])): ?>
                <?php $__currentLoopData = $dropdownFields['marital_status']->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($option->id); ?>"><?php echo e($option->option_value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        `;

        // Calculate reference count from old values
        <?php
            $oldReferenceCount = 0;
            foreach (old() as $key => $value) {
                if (str_starts_with($key, 'reference_') && !str_contains($key, '_relation_id') && !str_contains($key, '_contact_no') && !empty($value)) {
                    $oldReferenceCount++;
                }
            }

            $oldCoApplicantCount = 1;
            while (old('co_applicant_' . ($oldCoApplicantCount + 1) . '_first_name')) {
                $oldCoApplicantCount++;
            }
        ?>
        window.oldReferences = <?php echo e(max(1, $oldReferenceCount)); ?>;
        window.oldCoApplicantCount = <?php echo e($oldCoApplicantCount); ?>;

        // Section visibility based on old values
        window.oldCoApplicantVisible = <?php echo e(old('co_applicant_first_name') ? 'true' : 'false'); ?>;
        window.oldGuarantorVisible = <?php echo e(old('guarantor_first_name') ? 'true' : 'false'); ?>;
    </script>
    <script src="<?php echo e(asset('assets/js/pages/lead-create.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views\admin\leads\create.blade.php ENDPATH**/ ?>