<?php $__env->startSection('content'); ?>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&family=Roboto+Mono:wght@400;500;600&display=swap" rel="stylesheet">
<style>
@media print {
    .no-print { display: none !important; }
    body { margin: 0; padding: 0; font-size: 12px; font-family: Arial, sans-serif; }
    @page { size: A4; margin: 10mm 8mm 0mm 8mm; }
    .print-card { border: 2px solid #000 !important; page-break-inside: avoid; max-width: 100% !important; margin: 0 !important; box-shadow: none !important; }
    .page-content { margin: 0 !important; padding: 0 !important; }
    .container-fluid { margin: 0 !important; padding: 0 !important; }
    .print-table { border-collapse: collapse !important; box-shadow: none !important; }
    .print-table td, .print-table th { border: 2px solid #000 !important; padding: 8px !important; font-size: 11px !important; }
    .print-header { border-bottom: 2px solid #000 !important; background: #f0f0f0 !important; color: #000 !important; padding: 12px !important; }
    .print-table th { background: #f8f8f8 !important; color: #000 !important; font-weight: bold !important; }
    .total-row { background: #f0f0f0 !important; color: #000 !important; font-weight: bold !important; }
    .total-row td { color: #000 !important; font-weight: bold !important; }
    .label-cell { background: #f8f8f8 !important; color: #000 !important; font-weight: bold !important; }
    .percentage-cell { background: #f8f8f8 !important; color: #000 !important; }
    .weight-cell { background: #f8f8f8 !important; color: #000 !important; }
    .sr-cell { background: #f8f8f8 !important; color: #000 !important; }
    .left-column { padding: 12px !important; }
    .right-column { padding: 12px !important; }
    .image-section { min-height: 150px !important; padding: 12px !important; background: #f8f8f8 !important; border: 2px solid #000 !important; box-shadow: none !important; }
    .cad-image { max-height: 130px !important; box-shadow: none !important; }
    .card-number { position: static !important; background: none !important; padding: 0 !important; transform: none !important; color: #000 !important; font-weight: bold !important; }
    * { -webkit-print-color-adjust: exact !important; color-adjust: exact !important; }
}

* {
    font-family: 'Poppins', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}

.simple-header {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    border-radius: 16px;
    padding: 24px;
    margin-bottom: 24px;
    border: 1px solid #e2e8f0;
}

.simple-header h4 {
    font-size: 28px;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
    letter-spacing: -0.5px;
}

.simple-header small {
    color: #64748b;
    font-size: 16px;
    margin: 4px 0 0 0;
    font-weight: 500;
    opacity: 1;
}

.print-card {
    border: 2px solid #667eea;
    font-family: 'Poppins', sans-serif;
    background: white;
    margin: 0 auto;
    max-width: 190mm;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
}

.print-header {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    color: #475569;
    text-align: center;
    padding: 12px;
    position: relative;
    border-bottom: 1px solid #cbd5e1;
}

.print-header h3 {
    font-weight: 700;
    font-size: 1.2rem;
    letter-spacing: 1px;
    text-transform: uppercase;
    color: #475569;
}

.card-number {
    position: absolute;
    right: 20px;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(71, 85, 105, 0.1);
    padding: 8px 15px;
    border-radius: 25px;
    font-weight: 700;
    font-size: 0.9rem;
    border: 1px solid rgba(71, 85, 105, 0.2);
    font-family: 'Roboto Mono', monospace;
    color: #475569;
}

.content-table {
    width: 100%;
    border-collapse: collapse;
}

.left-column {
    width: 45%;
    vertical-align: top;
    padding: 12px;
}

.right-column {
    width: 55%;
    vertical-align: top;
    padding: 12px;
}

.print-table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 10px;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    font-family: 'Poppins', sans-serif;
}

.print-table td {
    border: 1px solid #e2e8f0;
    padding: 8px;
    font-size: 0.8rem;
    font-weight: 500;
    transition: all 0.3s ease;
    font-family: 'Poppins', sans-serif;
}

.print-table th {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    color: #475569;
    border: 1px solid #cbd5e1;
    padding: 10px 8px;
    font-size: 0.6rem;
    text-align: center;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.label-cell {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    font-weight: 700;
    width: 35%;
    color: #475569;
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.print-table tbody tr:hover {
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);
    transform: scale(1.01);
}

.image-section {
    border: 2px solid #cbd5e1;
    border-radius: 10px;
    padding: 12px;
    text-align: center;
    min-height: 140px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: white;
}

.cad-image {
    max-width: 100%;
    max-height: 120px;
    border-radius: 8px;
}

.total-row {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%) !important;
    color: #475569 !important;
    font-weight: 800 !important;
}

.total-row td {
    font-size: 1rem !important;
    letter-spacing: 0.5px !important;
    color: #475569 !important;
}

.creative-btn {
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    border: none;
    color: white;
    padding: 12px 24px;
    border-radius: 12px;
    font-weight: 600;
    font-size: 0.9rem;
    letter-spacing: 0.5px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
    text-decoration: none;
}

.creative-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(59, 130, 246, 0.4);
    color: white;
}

.yarn-data {
    font-family: 'Poppins', sans-serif;
    font-weight: 500;
}

.percentage-cell {
    background: linear-gradient(135deg, #f0f9f0 0%, #e8f5e8 100%);
    color: #2d5016;
    font-weight: 700;
    font-family: 'Poppins', sans-serif;
}

.weight-cell {
    background: linear-gradient(135deg, #f0f4f9 0%, #e1ecf4 100%);
    color: #1e3a5f;
    font-weight: 700;
    font-family: 'Poppins', sans-serif;
}

.sr-cell {
    background: linear-gradient(135deg, #faf0f9 0%, #f0e1ec 100%);
    color: #5d2a54;
    font-weight: 700;
    font-family: 'Poppins', sans-serif;
}
</style>

<div class="page-content">
    <div class="container-fluid">
        <!-- Header Section - Hidden in Print -->
        <div class="simple-header no-print">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h4 class="mb-0">Product Card Details</h4>
                </div>
                <div>
                    <button onclick="window.print()" class="creative-btn me-2">
                        <i class="fas fa-print"></i> Print
                    </button>
                    <a href="<?php echo e(route('product.index')); ?>" class="creative-btn">
                        <i class="fas fa-arrow-left"></i> Back
                    </a>
                </div>
            </div>
        </div>

        <!-- Print Card -->
        <div class="print-card">
            <div class="print-header">
                <h3 style="margin: 0; font-size: 18px; font-weight: bold;">PRODUCT CARD</h3>
                <div class="card-number">Card No: <?php echo e($product->product_card_no); ?></div>
            </div>
            
            <table class="content-table">
                <tr>
                    <td class="left-column">
                        <table class="print-table">
                            <tr><td class="label-cell">Product Name</td><td><?php echo e($product->product_name); ?></td></tr>
                            <tr><td class="label-cell">Co Design</td><td><?php echo e($dropdownFields['co_deisgn']->options->where('id', $product->co_design)->first()->option_value ?? 'N/A'); ?></td></tr>
                            <tr><td class="label-cell">Standard Size</td><td><?php echo e($dropdownFields['standard_size']->options->where('id', $product->standard_size)->first()->option_value ?? 'N/A'); ?></td></tr>
                            <tr><td class="label-cell">Color</td><td><?php echo e($dropdownFields['color']->options->where('id', $product->color)->first()->option_value ?? 'N/A'); ?></td></tr>
                            <tr><td class="label-cell">Collection</td><td><?php echo e($dropdownFields['collection']->options->where('id', $product->collection)->first()->option_value ?? 'N/A'); ?></td></tr>
                            <tr><td class="label-cell">Shape</td><td><?php echo e($dropdownFields['shape']->options->where('id', $product->shape)->first()->option_value ?? 'N/A'); ?></td></tr>
                            <tr><td class="label-cell">Style</td><td><?php echo e($dropdownFields['style']->options->where('id', $product->style)->first()->option_value ?? 'N/A'); ?></td></tr>
                            <tr><td class="label-cell">Customer Design</td><td><?php echo e($dropdownFields['customer_design']->options->where('id', $product->customer_design)->first()->option_value ?? 'N/A'); ?></td></tr>
                            <tr><td class="label-cell">Quality</td><td><?php echo e($dropdownFields['quality']->options->where('id', $product->quality)->first()->option_value ?? 'N/A'); ?></td></tr>
                            <tr><td class="label-cell">Weave</td><td><?php echo e($dropdownFields['weave']->options->where('id', $product->weave)->first()->option_value ?? 'N/A'); ?></td></tr>
                            <tr><td class="label-cell">Created Date</td><td><?php echo e($product->created_at->format('d-m-Y')); ?></td></tr>
                        </table>
                    </td>
                    <td class="right-column">
                        <table class="print-table">
                            <thead>
                                <tr>
                                    <th style="width: 12%;">Sr.</th>
                                    <th style="width: 28%;">Shade No.</th>
                                    <th style="width: 16%;">Percentage</th>
                                    <th style="width: 16%;">Kilogram</th>
                                    <th style="width: 28%;">Yarn</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if($product->yarn_shade_data): ?>
                                    <?php $__currentLoopData = $product->yarn_shade_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="sr-cell" style="text-align: center;"><?php echo e($index + 1); ?></td>
                                        <td class="yarn-data"><?php echo e(\App\Models\FormFieldOption::find($data['shade_id'])->option_value ?? 'N/A'); ?></td>
                                        <td class="percentage-cell" style="text-align: center;"><?php echo e(number_format($data['percentage'], 3)); ?></td>
                                        <td class="weight-cell" style="text-align: center;"><?php echo e(number_format($data['kilogram'], 3)); ?></td>
                                        <td class="yarn-data"><?php echo e($dropdownFields['yarn']->options->where('id', $data['yarn_id'])->first()->option_value ?? 'N/A'); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php for($i = count($product->yarn_shade_data); $i < 20; $i++): ?>
                                    <tr>
                                        <td class="sr-cell" style="text-align: center;"><?php echo e($i + 1); ?></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <?php endfor; ?>
                                <?php else: ?>
                                    <?php for($i = 1; $i <= 20; $i++): ?>
                                    <tr>
                                        <td class="sr-cell" style="text-align: center;"><?php echo e($i); ?></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <?php endfor; ?>
                                <?php endif; ?>
                            </tbody>
                            <tfoot>
                                <tr class="total-row">
                                    <td colspan="2" style="text-align: right; font-weight: bold;">TOTAL:</td>
                                    <td style="text-align: center; font-weight: bold;"><?php echo e(number_format($product->total_percentage, 3)); ?></td>
                                    <td style="text-align: center; font-weight: bold;"><?php echo e(number_format($product->total_kilogram, 3)); ?></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                        
                        <div class="image-section">
                            <?php if($product->cad_photo): ?>
                                <img src="<?php echo e(asset('storage/' . $product->cad_photo)); ?>" alt="CAD Design" class="cad-image">
                            <?php else: ?>
                                <div style="color: #666; font-size: 14px; position: relative; z-index: 2;">CAD DESIGN PHOTO</div>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views\admin\product\show.blade.php ENDPATH**/ ?>