<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">Designation / Roles </h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Role Masters</a></li>
                                <li class="breadcrumb-item active">Designation / Roles</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Add Designation / Roles</h4>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('designation.store')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="mb-3">
                                            <label for="designation_name" class="form-label">Designation/Role Name</label>
                                            <input type="text" class="form-control" id="designation_name"
                                                name="designation_name" placeholder="Enter designation name"
                                                value="<?php echo e(old('designation_name')); ?>" required>
                                            <?php $__errorArgs = ['designation_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="text-danger"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3">
                                            <label for="authorities" class="form-label">Authorities <i
                                                    class="ri-information-line" data-bs-toggle="tooltip"
                                                    data-bs-placement="top" data-bs-html="true"
                                                    title="For highest authority admin enter 1 - admin can manage upper levels (2,3,4,etc).<br><br>For lower level subadmin/branch manager enter 2 - subadmin can manage upper levels (3,4,etc).<br><br>For branch staff enter 3 - staff can manage upper levels (4,5,etc).<br><br>For RO enter 99."
                                                    style="font-size: 15px;"></i></label>
                                            <input type="number" class="form-control" id="authorities" name="authorities"
                                                placeholder="Enter authorities level" value="<?php echo e(old('authorities')); ?>">
                                            <?php $__errorArgs = ['authorities'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="text-danger"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="hstack gap-2 justify-content-end">
                                            <button type="submit" class="btn btn-primary">SAVE</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title mb-0">Designations/Role List</h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive table-card">
                                <table class="table align-middle table-nowrap table-striped-columns mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th width="5%">Sr No</th>
                                            <th width="45%">Designation/Role Name</th>
                                            <th width="15%">Authorities</th>
                                            <th width="15%">Status</th>
                                            <th width="20%">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $designations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $designation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($designation->name); ?></td>
                                                <td><?php echo e($designation->authorities ?? 'N/A'); ?></td>
                                                <td>
                                                    <span
                                                        class="badge bg-<?php echo e($designation->status ? 'success' : 'danger'); ?>">
                                                        <?php echo e($designation->status ? 'Active' : 'Inactive'); ?>

                                                    </span>
                                                </td>
                                                <td>
                                                    <form method="POST"
                                                        action="<?php echo e(route('designation.toggle-status', $designation->id)); ?>"
                                                        style="display:inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PATCH'); ?>
                                                        <button type="submit"
                                                            class="btn btn-sm btn-<?php echo e($designation->status ? 'warning' : 'success'); ?>">
                                                            <?php echo e($designation->status ? 'Deactivate' : 'Activate'); ?>

                                                        </button>
                                                    </form>
                                                    <button class="btn btn-sm btn-primary"
                                                        onclick="editDesignation(<?php echo e($designation->id); ?>, '<?php echo e($designation->name); ?>', <?php echo e($designation->authorities ?? 'null'); ?>)">Edit</button>
                                                    <form method="POST"
                                                        action="<?php echo e(route('designation.destroy', $designation->id)); ?>"
                                                        style="display:inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                            onclick="return confirm('Are you sure?')">Delete</button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="5" class="text-center">No designations found</td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Edit Modal -->
            <div class="modal fade" id="editModal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Edit Designation/Role</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <form id="editForm" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label for="edit_designation_name" class="form-label">Designation/Role Name</label>
                                    <input type="text" class="form-control" id="edit_designation_name"
                                        name="designation_name" required>
                                </div>
                                <div class="mb-3">
                                    <label for="edit_authorities" class="form-label">Authorities</label>
                                    <input type="number" class="form-control" id="edit_authorities" name="authorities"
                                        placeholder="Enter authorities level">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <script>
        function editDesignation(id, name, authorities) {
            document.getElementById('edit_designation_name').value = name;
            document.getElementById('edit_authorities').value = authorities || '';
            document.getElementById('editForm').action = '/masters/user-role/designation/' + id;
            new bootstrap.Modal(document.getElementById('editModal')).show();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views/masters/designation/designation.blade.php ENDPATH**/ ?>