<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">All Submenus</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Menu Masters</a></li>
                                <li class="breadcrumb-item active">All Submenus</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Submenu Management</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Menu / Submenu Name</th>
                                        <th>Parent</th>
                                        <th>Priority</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="table-info">
                                        <td><strong><?php echo e($menu->name); ?></strong></td>
                                        <td>-</td>
                                        <td><strong><?php echo e($menu->priority); ?></strong></td>
                                        <td>
                                            <span class="badge <?php echo e($menu->status ? 'bg-success' : 'bg-danger'); ?>">
                                                <?php echo e($menu->status ? 'Active' : 'Inactive'); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('submenu.index', $menu->id)); ?>" class="btn btn-sm btn-primary">
                                                Manage Submenus
                                            </a>
                                        </td>
                                    </tr>
                                    <?php $__currentLoopData = $subMenus->where('menu_id', $menu->id)->where('parent_id', null)->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parentSubmenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="table-light">
                                        <td class="ps-4">└─ <?php echo e($parentSubmenu->name); ?></td>
                                        <td>-</td>
                                        <td><?php echo e($parentSubmenu->priority); ?></td>
                                        <td>
                                            <span class="badge <?php echo e($parentSubmenu->status ? 'bg-success' : 'bg-danger'); ?>">
                                                <?php echo e($parentSubmenu->status ? 'Active' : 'Inactive'); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('submenu.index', $menu->id)); ?>" class="btn btn-sm btn-primary">
                                                Manage
                                            </a>
                                        </td>
                                    </tr>
                                    <?php $__currentLoopData = $subMenus->where('parent_id', $parentSubmenu->id)->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childSubmenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="ps-5">└─ <?php echo e($childSubmenu->name); ?></td>
                                        <td><?php echo e($parentSubmenu->name); ?></td>
                                        <td><?php echo e($childSubmenu->priority); ?></td>
                                        <td>
                                            <span class="badge <?php echo e($childSubmenu->status ? 'bg-success' : 'bg-danger'); ?>">
                                                <?php echo e($childSubmenu->status ? 'Active' : 'Inactive'); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('submenu.index', $menu->id)); ?>" class="btn btn-sm btn-primary">
                                                Manage
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        </div>
        <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views/masters/menu/all-submenu.blade.php ENDPATH**/ ?>