<?php $__env->startSection('content'); ?>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
* {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}
.modern-form {
    background: white;
    border-radius: 16px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    border: none;
    overflow: hidden;
}
.form-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 24px;
}
.form-title {
    font-size: 24px;
    font-weight: 700;
    margin: 0;
}
.form-subtitle {
    opacity: 0.9;
    margin: 4px 0 0 0;
    font-size: 14px;
}
.form-body {
    padding: 32px;
}
.form-group {
    margin-bottom: 24px;
}
.form-label {
    font-weight: 600;
    color: #374151;
    margin-bottom: 8px;
    font-size: 14px;
}
.form-control, .form-select {
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    padding: 12px 16px;
    font-size: 14px;
    transition: all 0.3s ease;
    /* background: #fafafa; */
}
.form-control:focus, .form-select:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    background: white;
}
.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    padding: 12px 32px;
    border-radius: 12px;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}
.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
}
.btn-secondary {
    background: #f8fafc;
    border: 2px solid #e2e8f0;
    color: #64748b;
    padding: 10px 24px;
    border-radius: 12px;
    font-weight: 500;
    transition: all 0.3s ease;
}
.btn-secondary:hover {
    background: #e2e8f0;
    border-color: #cbd5e1;
    color: #475569;
}
.header-section {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    border-radius: 16px;
    padding: 24px;
    margin-bottom: 24px;
    border: 1px solid #e2e8f0;
}
.page-title {
    font-size: 28px;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}
.page-subtitle {
    color: #64748b;
    font-size: 16px;
    margin: 4px 0 0 0;
}
.field-icon {
    width: 40px;
    height: 40px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 18px;
    color: white;
    margin-right: 12px;
}
.invalid-feedback {
    font-size: 12px;
    font-weight: 500;
}
.form-control.is-invalid, .form-select.is-invalid {
    border-color: #ef4444;
    background: #fef2f2;
}
</style>

<div class="page-content">
    <div class="container-fluid">
        <div class="header-section">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="page-title">Edit Option</h1>
                    <p class="page-subtitle">Update option for "<?php echo e($formField->field_label); ?>"</p>
                </div>
                <a href="<?php echo e(route('form-fields.options.index', $formField)); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Options
                </a>
            </div>
        </div>

        <div class="modern-form">
            <div class="form-header">
                <div class="d-flex align-items-center">
                    <div class="field-icon" style="background: rgba(255,255,255,0.2);">
                        <i class="ri-add-fill"></i>
                    </div>
                    <div>
                        <h3 class="form-title text-white">Update Option: <?php echo e($option->option_value); ?></h3>
                        <p class="form-subtitle">Modify your option settings</p>
                    </div>
                </div>
            </div>
            
            <div class="form-body">
                <form method="POST" action="<?php echo e(route('form-fields.options.update', [$formField, $option])); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="option_value" class="form-label">
                                    <i class="fas fa-tag me-2 text-primary"></i>Option Value
                                </label>
                                <input type="text" class="form-control <?php $__errorArgs = ['option_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="option_value" name="option_value" value="<?php echo e(old('option_value', $option->option_value)); ?>" 
                                       placeholder="e.g., Premium Category" required>
                                <?php $__errorArgs = ['option_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <?php if($formField->parent_field_id): ?>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="parent_id" class="form-label">
                                    <i class="fas fa-link me-2 text-info"></i>Master Option
                                </label>
                                <select class="form-select <?php $__errorArgs = ['parent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="parent_id" name="parent_id">
                                    <option value="">Select master option...</option>
                                    <?php if(isset($masterOptions)): ?>
                                        <?php $__currentLoopData = $masterOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $masterOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($masterOption->id); ?>" <?php echo e(old('parent_id', $option->parent_id) == $masterOption->id ? 'selected' : ''); ?>>
                                                <?php echo e($masterOption->option_value); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['parent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="priority" class="form-label">
                                    <i class="fas fa-sort-numeric-up me-2 text-warning"></i>Priority
                                </label>
                                <input type="number" class="form-control <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="priority" name="priority" value="<?php echo e(old('priority', $option->priority)); ?>" 
                                       placeholder="0" min="0">
                                <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="status" class="form-label">
                                    <i class="fas fa-toggle-on me-2 text-success"></i>Status
                                </label>
                                <select class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="status" required>
                                    <option value="1" <?php echo e(old('status', $option->status) == 1 ? 'selected' : ''); ?>>✅ Active</option>
                                    <option value="0" <?php echo e(old('status', $option->status) == 0 ? 'selected' : ''); ?>>❌ Inactive</option>
                                </select>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-end gap-3 mt-4 pt-4 border-top">
                        <a href="<?php echo e(route('form-fields.options.index', $formField)); ?>" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Option
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views\admin\master\form-field-options\edit.blade.php ENDPATH**/ ?>