<?php $__env->startSection('content'); ?>
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                    <h4 class="mb-sm-0">City</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Location Masters</a></li>
                            <li class="breadcrumb-item active">City</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Add City</h4>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('city.store')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="state_id" class="form-label">State</label>
                                        <select class="form-select" id="state_id" name="state_id" required>
                                            <option value="">Select State</option>
                                            <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($state->id); ?>" <?php echo e(old('state_id') == $state->id ? 'selected' : ''); ?>><?php echo e($state->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['state_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="district_id" class="form-label">District</label>
                                        <select class="form-select" id="district_id" name="district_id" required>
                                            <option value="">Select District</option>
                                        </select>
                                        <?php $__errorArgs = ['district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="city_name" class="form-label">City Name</label>
                                        <input type="text" class="form-control" id="city_name" name="city_name" placeholder="Enter city name" value="<?php echo e(old('city_name')); ?>" required>
                                        <?php $__errorArgs = ['city_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-lg-12">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary">SAVE</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Cities List</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive table-card">
                            <table class="table align-middle table-nowrap table-striped-columns mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th width="5%">Sr No</th>
                                        <th width="20%">State</th>
                                        <th width="20%">District</th>

                                        <th width="20%">City Name</th>
                                        <th width="8%">Status</th>
                                        <th width="7%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($cities->firstItem() + $index); ?></td>
                                            <td><?php echo e($city->state->name); ?></td>
                                            <td><?php echo e($city->district->name); ?></td>

                                            <td><?php echo e($city->name); ?></td>
                                            <td>
                                                <span class="badge bg-<?php echo e($city->status ? 'success' : 'danger'); ?>">
                                                    <?php echo e($city->status ? 'Active' : 'Inactive'); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <form method="POST" action="<?php echo e(route('city.toggle-status', $city->id)); ?>" style="display:inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PATCH'); ?>
                                                    <button type="submit" class="btn btn-sm btn-<?php echo e($city->status ? 'warning' : 'success'); ?>">
                                                        <?php echo e($city->status ? 'Deactivate' : 'Activate'); ?>

                                                    </button>
                                                </form>
                                                <button class="btn btn-sm btn-primary" onclick="editCity(<?php echo e($city->id); ?>, '<?php echo e($city->name); ?>', <?php echo e($city->state_id); ?>, <?php echo e($city->district_id); ?>)">Edit</button>
                                                <form method="POST" action="<?php echo e(route('city.destroy', $city->id)); ?>" style="display:inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="6" class="text-center">No cities found</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="d-flex justify-content-center mt-5">
                            <?php echo e($cities->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Edit Modal -->
        <div class="modal fade" id="editModal" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit City</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <form id="editForm" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="edit_state_id" class="form-label">State</label>
                                        <select class="form-select" id="edit_state_id" name="state_id" required>
                                            <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="edit_district_id" class="form-label">District</label>
                                        <select class="form-select" id="edit_district_id" name="district_id" required>
                                            <option value="">Select District</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="edit_city_name" class="form-label">City Name</label>
                                        <input type="text" class="form-control" id="edit_city_name" name="city_name" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
    <!-- container-fluid -->
</div>
<!-- End Page-content -->

<script>
// Load districts based on state selection
document.getElementById('state_id').addEventListener('change', function() {
    const stateId = this.value;
    const districtSelect = document.getElementById('district_id');
    
    districtSelect.innerHTML = '<option value="">Select District</option>';
    
    if (stateId) {
        fetch(`/api/districts/${stateId}`)
            .then(response => response.json())
            .then(districts => {
                districts.forEach(district => {
                    districtSelect.innerHTML += `<option value="${district.id}">${district.name}</option>`;
                });
            });
    }
});

// Edit modal district loading
document.getElementById('edit_state_id').addEventListener('change', function() {
    const stateId = this.value;
    const districtSelect = document.getElementById('edit_district_id');
    
    districtSelect.innerHTML = '<option value="">Select District</option>';
    
    if (stateId) {
        fetch(`/api/districts/${stateId}`)
            .then(response => response.json())
            .then(districts => {
                districts.forEach(district => {
                    districtSelect.innerHTML += `<option value="${district.id}">${district.name}</option>`;
                });
            });
    }
});

function editCity(id, name, stateId, districtId) {
    document.getElementById('edit_city_name').value = name;
    document.getElementById('edit_state_id').value = stateId;
    
    // Load districts for the selected state
    fetch(`/api/districts/${stateId}`)
        .then(response => response.json())
        .then(districts => {
            const districtSelect = document.getElementById('edit_district_id');
            districtSelect.innerHTML = '<option value="">Select District</option>';
            districts.forEach(district => {
                const selected = district.id == districtId ? 'selected' : '';
                districtSelect.innerHTML += `<option value="${district.id}" ${selected}>${district.name}</option>`;
            });
        });
    
    document.getElementById('editForm').action = '/masters/location/city/' + id;
    new bootstrap.Modal(document.getElementById('editModal')).show();
}
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views\masters\location\city.blade.php ENDPATH**/ ?>