<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\StateController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\DistrictController;
use App\Http\Controllers\DesignationController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\BranchController;
use App\Http\Controllers\BranchEmployeeController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\FormFieldController;
use App\Http\Controllers\FormFieldOptionController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\LeadController;
use App\Models\Permission;
use App\Helpers\RoleHelper;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CustomerController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    try {
        /** @var \App\Models\User $user */
        $user = Auth::user();

        if (!$user) {
            return redirect()->route('login');
        }

        if ($user->isAdmin()) {
            return redirect()->route('admin.dashboard');
        }

        return redirect()->route('user.dashboard');
    } catch (\Exception $e) {
        Log::error('Dashboard route error: ' . $e->getMessage());
        return redirect()->route('login')->with('error', 'An error occurred. Please try again.');
    }
})->middleware(['auth', 'verified'])->name('dashboard');

// Admin routes
Route::middleware(['auth', 'verified'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', function () {
        try {
            /** @var \App\Models\User $user */
            $user = Auth::user();
            if (!$user->hasRole('admin')) {
                abort(403, 'Unauthorized access.');
            }
            return view('admin.dashboard');
        } catch (\Exception $e) {
            Log::error('Admin dashboard error: ' . $e->getMessage());
            return redirect()->route('dashboard')->with('error', 'Unable to load admin dashboard.');
        }
    })->name('dashboard');
});

// User routes
Route::middleware(['auth', 'verified'])->prefix('user')->name('user.')->group(function () {
    Route::get('/dashboard', function () {
        try {
            /** @var \App\Models\User $user */
            $user = Auth::user();
            if ($user->hasRole('admin')) {
                return redirect()->route('admin.dashboard');
            }
            return view('user.dashboard');
        } catch (\Exception $e) {
            Log::error('User dashboard error: ' . $e->getMessage());
            return redirect()->route('dashboard')->with('error', 'Unable to load user dashboard.');
        }
    })->name('dashboard');
});

Route::middleware(['auth', 'permission'])->group(function () {

    // state Management Routes
    Route::get('/masters/location/state', [StateController::class, 'index'])->name('state.index');
    Route::post('/masters/location/state', [StateController::class, 'store'])->name('state.store');
    Route::put('/masters/location/state/{state}', [StateController::class, 'update'])->name('state.update');
    Route::delete('/masters/location/state/{state}', [StateController::class, 'destroy'])->name('state.destroy');
    Route::patch('/masters/location/state/{state}/toggle-status', [StateController::class, 'toggleStatus'])->name('state.toggle-status');

    // city Management Routes
    Route::get('/masters/location/city', [CityController::class, 'index'])->name('city.index');
    Route::post('/masters/location/city', [CityController::class, 'store'])->name('city.store');
    Route::put('/masters/location/city/{city}', [CityController::class, 'update'])->name('city.update');
    Route::delete('/masters/location/city/{city}', [CityController::class, 'destroy'])->name('city.destroy');
    Route::patch('/masters/location/city/{city}/toggle-status', [CityController::class, 'toggleStatus'])->name('city.toggle-status');
    Route::get('/api/districts/{state}', [EmployeeController::class, 'getDistricts'])->name('api.districts');

    // distict Management Routes
    Route::get('/masters/location/district', [DistrictController::class, 'index'])->name('district.index');
    Route::post('/masters/location/district', [DistrictController::class, 'store'])->name('district.store');
    Route::put('/masters/location/district/{district}', [DistrictController::class, 'update'])->name('district.update');
    Route::delete('/masters/location/district/{district}', [DistrictController::class, 'destroy'])->name('district.destroy');
    Route::patch('/masters/location/district/{district}/toggle-status', [DistrictController::class, 'toggleStatus'])->name('district.toggle-status');

    // branch Management Routes
    Route::get('/masters/location/branch', [BranchController::class, 'index'])->name('branch.index');
    Route::post('/masters/location/branch', [BranchController::class, 'store'])->name('branch.store');
    Route::put('/masters/location/branch/{branch}', [BranchController::class, 'update'])->name('branch.update');
    Route::delete('/masters/location/branch/{branch}', [BranchController::class, 'destroy'])->name('branch.destroy');
    Route::patch('/masters/location/branch/{branch}/toggle-status', [BranchController::class, 'toggleStatus'])->name('branch.toggle-status');

    // Branch Employee Management Routes
    Route::get('/masters/branch/branch-employees', [BranchEmployeeController::class, 'index'])->name('branch-employees.index');
    Route::get('/masters/branch/add-employee', [BranchEmployeeController::class, 'create'])->name('branch-employees.create');
    Route::get('/masters/branch/employee/{employee}/edit', [BranchEmployeeController::class, 'edit'])->name('branch-employees.edit');

    // Form Fields Management Routes
    Route::resource('form-fields', FormFieldController::class);
    Route::resource('form-fields.options', FormFieldOptionController::class)->except(['show']);
    Route::get('/admin/form-fields/{formField}/options', [FormFieldController::class, 'getOptions'])->name('form-fields.options');

    // Role Master Routes
    Route::get('/masters/user-role/department', [DepartmentController::class, 'index'])->name('department.index');
    Route::post('/masters/user-role/department', [DepartmentController::class, 'store'])->name('department.store');
    Route::put('/masters/user-role/department/{department}', [DepartmentController::class, 'update'])->name('department.update');
    Route::delete('/masters/user-role/department/{department}', [DepartmentController::class, 'destroy'])->name('department.destroy');
    Route::patch('/masters/user-role/department/{department}/toggle-status', [DepartmentController::class, 'toggleStatus'])->name('department.toggle-status');

    // Role Master Routes
    Route::get('/masters/user-role/designation', [DesignationController::class, 'index'])->name('designation.index');
    Route::post('/masters/user-role/designation', [DesignationController::class, 'store'])->name('designation.store');
    Route::put('/masters/user-role/designation/{designation}', [DesignationController::class, 'update'])->name('designation.update');
    Route::delete('/masters/user-role/designation/{designation}', [DesignationController::class, 'destroy'])->name('designation.destroy');
    Route::patch('/masters/user-role/designation/{designation}/toggle-status', [DesignationController::class, 'toggleStatus'])->name('designation.toggle-status');

    // Menu Management Routes
    Route::get('/masters/menu/menu', [MenuController::class, 'index'])->name('menu.index');
    Route::post('/masters/menu/menu', [MenuController::class, 'store'])->name('menu.store');
    Route::put('/masters/menu/menu/{menu}', [MenuController::class, 'update'])->name('menu.update');
    Route::delete('/masters/menu/menu/{menu}', [MenuController::class, 'destroy'])->name('menu.destroy');
    Route::patch('/masters/menu/menu/{menu}/toggle-status', [MenuController::class, 'toggleStatus'])->name('menu.toggle-status');

    // SubMenu Management Routes
    Route::get('/masters/menu/submenu', [MenuController::class, 'allSubMenus'])->name('submenu.all');
    Route::get('/masters/menu/{menu}/submenu', [MenuController::class, 'subMenus'])->name('submenu.index');
    Route::post('/masters/menu/{menu}/submenu', [MenuController::class, 'storeSubMenu'])->name('submenu.store');
    Route::put('/masters/menu/{menu}/submenu/{submenu}', [MenuController::class, 'updateSubMenu'])->name('submenu.update');
    Route::delete('/masters/menu/{menu}/submenu/{submenu}', [MenuController::class, 'destroySubMenu'])->name('submenu.destroy');
    Route::patch('/masters/menu/{menu}/submenu/{submenu}/toggle-status', [MenuController::class, 'toggleSubMenuStatus'])->name('submenu.toggle-status');

    // Permission Management Routes
    Route::get('/masters/user-role/permissions', [PermissionController::class, 'index'])->name('permissions.index');
    Route::post('/masters/user-role/permissions', [PermissionController::class, 'store'])->name('permissions.store');
    Route::get('/api/submenus/{menu}', [PermissionController::class, 'getSubMenus'])->name('api.submenus');
    Route::get('/api/role-permissions/{role}', [PermissionController::class, 'getRolePermissions'])->name('api.role-permissions');
    Route::delete('/api/role-permissions/{role}/reset', [PermissionController::class, 'resetRolePermissions'])->name('api.reset-permissions');


    // Team Management Routes
    Route::get('/team/add-employee', [EmployeeController::class, 'create'])->name('employee.create');
    Route::post('/team/add-employee', [EmployeeController::class, 'store'])->name('employee.store');
    Route::get('/team/employee-list', [EmployeeController::class, 'index'])->name('employee.index');
    Route::get('/team/employee/{employee}/edit', [EmployeeController::class, 'edit'])->name('employee.edit');
    Route::put('/team/employee/{employee}', [EmployeeController::class, 'update'])->name('employee.update');
    Route::delete('/team/employee/{employee}', [EmployeeController::class, 'destroy'])->name('employee.destroy');
    Route::patch('/team/employee/{employee}/toggle-status', [EmployeeController::class, 'toggleStatus'])->name('employee.toggle-status');
    Route::patch('/team/employee/{employee}/change-password', [EmployeeController::class, 'changePassword'])->name('employee.change-password');
    Route::get('/api/cities/{district}', [EmployeeController::class, 'getCities'])->name('api.cities');
    Route::get('/profile-settings', [EmployeeController::class, 'profileIndex'])->name('profile-settings.get');
    Route::post('/profile/update', [EmployeeController::class, 'profileUpdate'])->name('profile.update');
    Route::post('/profile/change-password', [EmployeeController::class, 'profileChangePassword'])->name('profile.change-password');
    Route::get('/document/{type}/{filename}', [EmployeeController::class, 'viewDocument'])->name('document.view');

    // Settings Management Routes
    // Route::get('/masters/settings', [SettingController::class, 'index'])->name('settings.index');
    // Route::post('/masters/settings', [SettingController::class, 'store'])->name('settings.store');

    // Lead Management Routes
    // Route::get('/masters/lead-management/create-new-lead', [LeadController::class, 'create'])->name('lead.create');
    // Route::post('/masters/lead-management/create-new-lead', [LeadController::class, 'store'])->name('lead.store');
    // Route::get('/masters/lead-management/assign-lead', [LeadController::class, 'assignLead'])->name('lead.assign');
    // Route::get('/masters/lead-management/view/{applicant}', [LeadController::class, 'show'])->name('lead.show');
    // Route::get('/masters/lead-management/edit/{applicant}', [LeadController::class, 'edit'])->name('lead.edit');
    // Route::put('/masters/lead-management/update/{applicant}', [LeadController::class, 'update'])->name('lead.update');
    // Route::delete('/masters/lead-management/lead/{applicant}', [LeadController::class, 'destroy'])->name('lead.destroy');
    // Route::post('/masters/lead-management/assign-lead-update', [LeadController::class, 'updateAssignment'])->name('lead.update-assignment');
    // Route::get('/lead/branch-verify/{applicant}', [LeadController::class, 'branchVerify'])->name('lead.branch-verify');
    // Route::get('/api/cities-by-state/{state}', [LeadController::class, 'getCitiesByState'])->name('api.cities-by-state');
    // Route::get('/api/branch-staff/{branch}', [LeadController::class, 'getBranchStaff'])->name('api.branch-staff');

    // Product Management Routes
    Route::get('/product/add-product', [ProductController::class, 'create'])->name('product.create');
    Route::post('/product/add-product', [ProductController::class, 'store'])->name('product.store');
    Route::get('/product/product-list', [ProductController::class, 'index'])->name('product.index');
    Route::get('/product/view/{product}', [ProductController::class, 'show'])->name('product.show');
    Route::get('/product/edit/{product}', [ProductController::class, 'edit'])->name('product.edit');
    Route::put('/product/edit/{product}', [ProductController::class, 'update'])->name('product.update');
    Route::get('/api/shade-options/{yarnId}', [ProductController::class, 'getShadeOptions'])->name('api.shade-options');
    
    // Customer Management Routes
    Route::get('/customer/create-customer', [CustomerController::class, 'create'])->name('customer.create');
    Route::post('/customer/create-customer', [CustomerController::class, 'store'])->name('customer.store');
    Route::get('/customer/customer-list', [CustomerController::class, 'index'])->name('customer.index');
    Route::get('/customer/edit/{customer}', [CustomerController::class, 'edit'])->name('customer.edit');
    Route::put('/customer/edit/{customer}', [CustomerController::class, 'update'])->name('customer.update');
    Route::delete('/customer/{customer}', [CustomerController::class, 'destroy'])->name('customer.destroy');
    
});

require __DIR__ . '/auth.php';
