@extends('layout.layout')
@section('content')
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SubMenu Management - {{ $menu->name }}</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Menu Masters</a></li>
                                <li class="breadcrumb-item active">SubMenu Management</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-12">
                    <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="card-title mb-0">SubMenu Management - {{ $menu->name }}</h4>
                        <a href="{{ route('menu.index') }}" class="btn btn-sm btn-secondary mt-2">← Back to Menus</a>
                    </div>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSubMenuModal">
                        Add SubMenu
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>SubMenu Name</th>
                                    <th>Priority</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($subMenus->where('parent_id', null)->sortBy('priority') as $parentSubmenu)
                                <tr style="background-color: rgba(53, 196, 77, 0.142);">
                                    <td><strong>{{ $parentSubmenu->id }}</strong></td>
                                    <td><strong>{{ $parentSubmenu->name }}</strong></td>
                                    <td><strong>{{ $parentSubmenu->priority }}</strong></td>
                                    <td>
                                        <span class="badge bg-{{ $parentSubmenu->status ? 'success' : 'danger' }}">
                                            {{ $parentSubmenu->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" onclick="editSubMenu({{ $parentSubmenu->id }}, '{{ $parentSubmenu->name }}', {{ $parentSubmenu->parent_id ?? 'null' }}, {{ $parentSubmenu->priority }}, '{{ $parentSubmenu->route }}')">Edit</button>
                                        <form method="POST" action="{{ route('submenu.toggle-status', [$menu->id, $parentSubmenu->id]) }}" class="d-inline">
                                            @csrf @method('PATCH')
                                            <button type="submit" class="btn btn-sm btn-{{ $parentSubmenu->status ? 'secondary' : 'success' }}">
                                                {{ $parentSubmenu->status ? 'Deactivate' : 'Activate' }}
                                            </button>
                                        </form>
                                        <form method="POST" action="{{ route('submenu.destroy', [$menu->id, $parentSubmenu->id]) }}" class="d-inline">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                @foreach($subMenus->where('parent_id', $parentSubmenu->id)->sortBy('priority') as $childSubmenu)
                                <tr>
                                    {{-- <td class="ps-4">{{ $childSubmenu->id }}</td> --}}
                                    <td class="ps-4">└─ {{ $childSubmenu->name }}</td>
                                    <td>{{ $childSubmenu->priority }}</td>
                                    <td>
                                        <span class="badge bg-{{ $childSubmenu->status ? 'success' : 'danger' }}">
                                            {{ $childSubmenu->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" onclick="editSubMenu({{ $childSubmenu->id }}, '{{ $childSubmenu->name }}', {{ $childSubmenu->parent_id ?? 'null' }}, {{ $childSubmenu->priority }}, '{{ $childSubmenu->route }}')">Edit</button>
                                        <form method="POST" action="{{ route('submenu.toggle-status', [$menu->id, $childSubmenu->id]) }}" class="d-inline">
                                            @csrf @method('PATCH')
                                            <button type="submit" class="btn btn-sm btn-{{ $childSubmenu->status ? 'secondary' : 'success' }}">
                                                {{ $childSubmenu->status ? 'Deactivate' : 'Activate' }}
                                            </button>
                                        </form>
                                        <form method="POST" action="{{ route('submenu.destroy', [$menu->id, $childSubmenu->id]) }}" class="d-inline">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add SubMenu Modal -->
<div class="modal fade" id="addSubMenuModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="{{ route('submenu.store', $menu->id) }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Add SubMenu</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">SubMenu Name</label>
                        <input type="text" name="submenu_name" class="form-control" value="{{ old('submenu_name') }}" required>
                        @error('submenu_name')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Route</label>
                        <input type="text" name="route" class="form-control" placeholder="/masters/location/state" value="{{ old('route') }}">
                        @error('route')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Parent SubMenu</label>
                        <select name="parent_id" class="form-control">
                            <option value="">None (Main SubMenu)</option>
                            @foreach($subMenus->where('parent_id', null) as $parentMenu)
                                <option value="{{ $parentMenu->id }}" {{ old('parent_id') == $parentMenu->id ? 'selected' : '' }}>{{ $parentMenu->name }}</option>
                            @endforeach
                        </select>
                        @error('parent_id')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Priority</label>
                        <input type="number" name="priority" class="form-control" min="0" value="{{ old('priority') }}" required>
                        @error('priority')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save SubMenu</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit SubMenu Modal -->
<div class="modal fade" id="editSubMenuModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" id="editSubMenuForm">
                @csrf @method('PUT')
                <div class="modal-header">
                    <h5 class="modal-title">Edit SubMenu</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">SubMenu Name</label>
                        <input type="text" name="submenu_name" id="edit_submenu_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Route</label>
                        <input type="text" name="route" id="edit_route" class="form-control" placeholder="/masters/location/state">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Parent SubMenu</label>
                        <select name="parent_id" id="edit_parent_id" class="form-control">
                            <option value="">None (Main SubMenu)</option>
                            @foreach($subMenus->where('parent_id', null) as $parentMenu)
                                <option value="{{ $parentMenu->id }}">{{ $parentMenu->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Priority</label>
                        <input type="number" name="priority" id="edit_submenu_priority" class="form-control" min="0" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update SubMenu</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editSubMenu(id, name, parentId, priority, route) {
    document.getElementById('edit_submenu_name').value = name;
    document.getElementById('edit_route').value = route || '';
    document.getElementById('edit_parent_id').value = parentId || '';
    document.getElementById('edit_submenu_priority').value = priority;
    document.getElementById('editSubMenuForm').action = '/masters/menu/{{ $menu->id }}/submenu/' + id;
    new bootstrap.Modal(document.getElementById('editSubMenuModal')).show();
}
</script>

        </div>
        <!-- container-fluid -->
    </div>
@endsection