@extends('layout.layout')
@section('content')
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                    <h4 class="mb-sm-0">State</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Location Masters</a></li>
                            <li class="breadcrumb-item active">State</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Add State</h4>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('state.store') }}">
                            @csrf
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="state_name" class="form-label">State Name</label>
                                        <input type="text" class="form-control" id="state_name" name="state_name" placeholder="Enter state name" value="{{ old('state_name') }}" required>
                                        @error('state_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>    
                            </div>
                            
                            <div class="col-lg-12">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary">SAVE</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">States List</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive table-card">
                            <table class="table align-middle table-nowrap table-striped-columns mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th width="5%">Sr No</th>
                                        <th width="60%">State Name</th>
                                        <th width="15%">Status</th>
                                        <th width="20%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($states as $index => $state)
                                        <tr>
                                            <td>{{ $states->firstItem() + $index }}</td>
                                            <td>{{ $state->name }}</td>
                                            <td>
                                                <span class="badge bg-{{ $state->status ? 'success' : 'danger' }}">
                                                    {{ $state->status ? 'Active' : 'Inactive' }}
                                                </span>
                                            </td>
                                            <td>
                                                <form method="POST" action="{{ route('state.toggle-status', $state->id) }}" style="display:inline">
                                                    @csrf
                                                    @method('PATCH')
                                                    <button type="submit" class="btn btn-sm btn-{{ $state->status ? 'warning' : 'success' }}">
                                                        {{ $state->status ? 'Deactivate' : 'Activate' }}
                                                    </button>
                                                </form>
                                                <button class="btn btn-sm btn-primary" onclick="editState({{ $state->id }}, '{{ $state->name }}')">Edit</button>
                                                <form method="POST" action="{{ route('state.destroy', $state->id) }}" style="display:inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="text-center">No states found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="d-flex justify-content-center mt-5">
                                {{ $states->links() }}
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Edit Modal -->
        <div class="modal fade" id="editModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit State</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <form id="editForm" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="edit_state_name" class="form-label">State Name</label>
                                <input type="text" class="form-control" id="edit_state_name" name="state_name" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
    <!-- container-fluid -->
</div>
<!-- End Page-content -->

<script>
function editState(id, name) {
    document.getElementById('edit_state_name').value = name;
    document.getElementById('editForm').action = '/masters/location/state/' + id;
    new bootstrap.Modal(document.getElementById('editModal')).show();
}
</script>

 @endsection

            