@extends('layout.layout')
@section('content')
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                    <h4 class="mb-sm-0">City</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Location Masters</a></li>
                            <li class="breadcrumb-item active">City</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Add City</h4>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('city.store') }}">
                            @csrf
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="state_id" class="form-label">State</label>
                                        <select class="form-select" id="state_id" name="state_id" required>
                                            <option value="">Select State</option>
                                            @foreach($states as $state)
                                                <option value="{{ $state->id }}" {{ old('state_id') == $state->id ? 'selected' : '' }}>{{ $state->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('state_id')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="district_id" class="form-label">District</label>
                                        <select class="form-select" id="district_id" name="district_id" required>
                                            <option value="">Select District</option>
                                        </select>
                                        @error('district_id')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="city_name" class="form-label">City Name</label>
                                        <input type="text" class="form-control" id="city_name" name="city_name" placeholder="Enter city name" value="{{ old('city_name') }}" required>
                                        @error('city_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-lg-12">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary">SAVE</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Cities List</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive table-card">
                            <table class="table align-middle table-nowrap table-striped-columns mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th width="5%">Sr No</th>
                                        <th width="20%">State</th>
                                        <th width="20%">District</th>

                                        <th width="20%">City Name</th>
                                        <th width="8%">Status</th>
                                        <th width="7%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($cities as $index => $city)
                                        <tr>
                                            <td>{{ $cities->firstItem() + $index }}</td>
                                            <td>{{ $city->state->name }}</td>
                                            <td>{{ $city->district->name }}</td>

                                            <td>{{ $city->name }}</td>
                                            <td>
                                                <span class="badge bg-{{ $city->status ? 'success' : 'danger' }}">
                                                    {{ $city->status ? 'Active' : 'Inactive' }}
                                                </span>
                                            </td>
                                            <td>
                                                <form method="POST" action="{{ route('city.toggle-status', $city->id) }}" style="display:inline">
                                                    @csrf
                                                    @method('PATCH')
                                                    <button type="submit" class="btn btn-sm btn-{{ $city->status ? 'warning' : 'success' }}">
                                                        {{ $city->status ? 'Deactivate' : 'Activate' }}
                                                    </button>
                                                </form>
                                                <button class="btn btn-sm btn-primary" onclick="editCity({{ $city->id }}, '{{ $city->name }}', {{ $city->state_id }}, {{ $city->district_id }})">Edit</button>
                                                <form method="POST" action="{{ route('city.destroy', $city->id) }}" style="display:inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center">No cities found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="d-flex justify-content-center mt-5">
                            {{ $cities->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Edit Modal -->
        <div class="modal fade" id="editModal" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit City</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <form id="editForm" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="edit_state_id" class="form-label">State</label>
                                        <select class="form-select" id="edit_state_id" name="state_id" required>
                                            @foreach($states as $state)
                                                <option value="{{ $state->id }}">{{ $state->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="edit_district_id" class="form-label">District</label>
                                        <select class="form-select" id="edit_district_id" name="district_id" required>
                                            <option value="">Select District</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="edit_city_name" class="form-label">City Name</label>
                                        <input type="text" class="form-control" id="edit_city_name" name="city_name" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
    <!-- container-fluid -->
</div>
<!-- End Page-content -->

<script>
// Load districts based on state selection
document.getElementById('state_id').addEventListener('change', function() {
    const stateId = this.value;
    const districtSelect = document.getElementById('district_id');
    
    districtSelect.innerHTML = '<option value="">Select District</option>';
    
    if (stateId) {
        fetch(`/api/districts/${stateId}`)
            .then(response => response.json())
            .then(districts => {
                districts.forEach(district => {
                    districtSelect.innerHTML += `<option value="${district.id}">${district.name}</option>`;
                });
            });
    }
});

// Edit modal district loading
document.getElementById('edit_state_id').addEventListener('change', function() {
    const stateId = this.value;
    const districtSelect = document.getElementById('edit_district_id');
    
    districtSelect.innerHTML = '<option value="">Select District</option>';
    
    if (stateId) {
        fetch(`/api/districts/${stateId}`)
            .then(response => response.json())
            .then(districts => {
                districts.forEach(district => {
                    districtSelect.innerHTML += `<option value="${district.id}">${district.name}</option>`;
                });
            });
    }
});

function editCity(id, name, stateId, districtId) {
    document.getElementById('edit_city_name').value = name;
    document.getElementById('edit_state_id').value = stateId;
    
    // Load districts for the selected state
    fetch(`/api/districts/${stateId}`)
        .then(response => response.json())
        .then(districts => {
            const districtSelect = document.getElementById('edit_district_id');
            districtSelect.innerHTML = '<option value="">Select District</option>';
            districts.forEach(district => {
                const selected = district.id == districtId ? 'selected' : '';
                districtSelect.innerHTML += `<option value="${district.id}" ${selected}>${district.name}</option>`;
            });
        });
    
    document.getElementById('editForm').action = '/masters/location/city/' + id;
    new bootstrap.Modal(document.getElementById('editModal')).show();
}
</script>

@endsection