@extends('layout.layout')

@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0">Branch Management</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                                <li class="breadcrumb-item active">Branch Management</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>


            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Add New Branch</h4>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('branch.store') }}" method="POST">
                                @csrf
                                <div class="row">
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="branch_name" class="form-label">Branch Name <span
                                                    class="text-danger">*</span></label>
                                            <input type="text"
                                                class="form-control @error('branch_name') is-invalid @enderror"
                                                id="branch_name" name="branch_name" value="{{ old('branch_name') }}"
                                                required>
                                            @error('branch_name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="branch_code" class="form-label">Branch Code <span
                                                    class="text-danger">*</span></label>
                                            <input type="text"
                                                class="form-control @error('branch_code') is-invalid @enderror"
                                                id="branch_code" name="branch_code" value="{{ old('branch_code') }}"
                                                required>
                                            @error('branch_code')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="state_id" class="form-label">State <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-select @error('state_id') is-invalid @enderror"
                                                id="state_id" name="state_id" required>
                                                <option value="">Select State</option>
                                                @foreach ($states as $state)
                                                    <option value="{{ $state->id }}"
                                                        {{ old('state_id') == $state->id ? 'selected' : '' }}>
                                                        {{ $state->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('state_id')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="district_id" class="form-label">District <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-select @error('district_id') is-invalid @enderror"
                                                id="district_id" name="district_id" required>
                                                <option value="">Select District</option>
                                            </select>
                                            @error('district_id')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="city_id" class="form-label">City <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-select @error('city_id') is-invalid @enderror"
                                                id="city_id" name="city_id" required>
                                                <option value="">Select City</option>
                                            </select>
                                            @error('city_id')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="pincode" class="form-label">Pincode</label>
                                            <input type="text"
                                                class="form-control @error('pincode') is-invalid @enderror" id="pincode"
                                                name="pincode" value="{{ old('pincode') }}" maxlength="6">
                                            @error('pincode')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label for="address" class="form-label">Address</label>
                                            <textarea class="form-control @error('address') is-invalid @enderror" id="address" name="address" rows="1">{{ old('address') }}</textarea>
                                            @error('address')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label class="form-label">Head Branch</label>
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="is_head_branch"
                                                    name="is_head_branch">
                                                <label class="form-check-label" for="is_head_branch">Yes</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label class="form-label">Active/Inactive Status</label>
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id=""
                                                    name="status" checked>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12" style="text-align: right;">
                                        <div class="mb-3">
                                            <label class="form-label">&nbsp;</label>
                                            <div>
                                                <button type="submit" class="btn btn-primary">Add Branch</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Branches List</h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Branch Name</th>
                                            <th>Branch Code</th>
                                            <th>Location</th>
                                            <th>Head Branch</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($branches as $key => $branch)
                                            <tr>
                                                <td>{{ $key+1 }}</td>
                                                <td>{{ $branch->branch_name }}</td>
                                                <td>{{ $branch->branch_code }}</td>
                                                <td>{{ $branch->city->name ?? '' }}, {{ $branch->district->name ?? '' }},
                                                    {{ $branch->state->name ?? '' }}</td>
                                                <td>
                                                    <span
                                                        class="badge bg-{{ $branch->is_head_branch ? 'primary' : 'secondary' }}">
                                                        {{ $branch->is_head_branch ? 'Yes' : 'No' }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="badge bg-{{ $branch->status ? 'success' : 'danger' }}">
                                                        {{ $branch->status ? 'Active' : 'Inactive' }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-primary"
                                                        onclick="editBranch({{ $branch }})">
                                                        Edit
                                                    </button>
                                                    <form action="{{ route('branch.toggle-status', $branch) }}"
                                                        method="POST" class="d-inline">
                                                        @csrf
                                                        @method('PATCH')
                                                        <button type="submit"
                                                            class="btn btn-sm btn-{{ $branch->status ? 'warning' : 'success' }}">
                                                            {{ $branch->status ? 'Deactivate' : 'Activate' }}
                                                        </button>
                                                    </form>
                                                    <form action="{{ route('branch.destroy', $branch) }}" method="POST"
                                                        class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                            onclick="return confirm('Are you sure you want to delete this branch?')">
                                                            Delete
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="7" class="text-center">No branches found</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

   

    <!-- Edit Branch Modal -->
    <div class="modal fade" id="editBranchModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form id="editBranchForm" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Branch</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="edit_branch_name" class="form-label">Branch Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="edit_branch_name" name="branch_name" required>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="edit_branch_code" class="form-label">Branch Code <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="edit_branch_code" name="branch_code" required>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="edit_state_id" class="form-label">State <span class="text-danger">*</span></label>
                                    <select class="form-select" id="edit_state_id" name="state_id" required>
                                        <option value="">Select State</option>
                                        @foreach($states as $state)
                                            <option value="{{ $state->id }}">{{ $state->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="edit_district_id" class="form-label">District <span class="text-danger">*</span></label>
                                    <select class="form-select" id="edit_district_id" name="district_id" required>
                                        <option value="">Select District</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="edit_city_id" class="form-label">City <span class="text-danger">*</span></label>
                                    <select class="form-select" id="edit_city_id" name="city_id" required>
                                        <option value="">Select City</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="edit_address" class="form-label">Address</label>
                                    <textarea class="form-control" id="edit_address" name="address" rows="2"></textarea>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="edit_pincode" class="form-label">Pincode</label>
                                    <input type="text" class="form-control" id="edit_pincode" name="pincode" maxlength="6">
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label class="form-label">Head Branch</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="edit_is_head_branch" name="is_head_branch">
                                        <label class="form-check-label" for="edit_is_head_branch">Yes</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label class="form-label">Active/Inactive Status</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="edit_status" name="status">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update Branch</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

     <script>
        // State change handler
        document.getElementById('state_id').addEventListener('change', function() {
            const stateId = this.value;
            const districtSelect = document.getElementById('district_id');
            const citySelect = document.getElementById('city_id');

            districtSelect.innerHTML = '<option value="">Select District</option>';
            citySelect.innerHTML = '<option value="">Select City</option>';

            if (stateId) {
                fetch(`/api/districts/${stateId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            data.data.forEach(district => {
                                districtSelect.innerHTML +=
                                    `<option value="${district.id}">${district.name}</option>`;
                            });
                        }
                    });
            }
        });

        // District change handler
        document.getElementById('district_id').addEventListener('change', function() {
            const districtId = this.value;
            const citySelect = document.getElementById('city_id');

            citySelect.innerHTML = '<option value="">Select City</option>';

            if (districtId) {
                fetch(`/api/cities/${districtId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            data.data.forEach(city => {
                                citySelect.innerHTML +=
                                    `<option value="${city.id}">${city.name}</option>`;
                            });
                        }
                    });
            }
        });

        // Edit modal state change handler
        document.addEventListener('change', function(e) {
            if (e.target.id === 'edit_state_id') {
                const stateId = e.target.value;
                const districtSelect = document.getElementById('edit_district_id');
                const citySelect = document.getElementById('edit_city_id');

                districtSelect.innerHTML = '<option value="">Select District</option>';
                citySelect.innerHTML = '<option value="">Select City</option>';

                if (stateId) {
                    fetch(`/api/districts/${stateId}`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                data.data.forEach(district => {
                                    districtSelect.innerHTML +=
                                        `<option value="${district.id}">${district.name}</option>`;
                                });
                            }
                        });
                }
            }
        });

        // Edit modal district change handler
        document.addEventListener('change', function(e) {
            if (e.target.id === 'edit_district_id') {
                const districtId = e.target.value;
                const citySelect = document.getElementById('edit_city_id');

                citySelect.innerHTML = '<option value="">Select City</option>';

                if (districtId) {
                    fetch(`/api/cities/${districtId}`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                data.data.forEach(city => {
                                    citySelect.innerHTML +=
                                        `<option value="${city.id}">${city.name}</option>`;
                                });
                            }
                        });
                }
            }
        });

        function editBranch(branch) {
            // Populate edit form fields
            document.getElementById('edit_branch_name').value = branch.branch_name;
            document.getElementById('edit_branch_code').value = branch.branch_code;
            document.getElementById('edit_state_id').value = branch.state_id;
            document.getElementById('edit_address').value = branch.address || '';
            document.getElementById('edit_pincode').value = branch.pincode || '';
            document.getElementById('edit_is_head_branch').checked = branch.is_head_branch;
            document.getElementById('edit_status').checked = branch.status;
            
            // Set form action
            document.getElementById('editBranchForm').action = `/masters/location/branch/${branch.id}`;
            
            // Load districts for selected state
            if (branch.state_id) {
                fetch(`/api/districts/${branch.state_id}`)
                    .then(response => response.json())
                    .then(data => {
                        const districtSelect = document.getElementById('edit_district_id');
                        districtSelect.innerHTML = '<option value="">Select District</option>';
                        if (data.success) {
                            data.data.forEach(district => {
                                const selected = district.id == branch.district_id ? 'selected' : '';
                                districtSelect.innerHTML += `<option value="${district.id}" ${selected}>${district.name}</option>`;
                            });
                        }
                        
                        // Load cities for selected district
                        if (branch.district_id) {
                            fetch(`/api/cities/${branch.district_id}`)
                                .then(response => response.json())
                                .then(data => {
                                    const citySelect = document.getElementById('edit_city_id');
                                    citySelect.innerHTML = '<option value="">Select City</option>';
                                    if (data.success) {
                                        data.data.forEach(city => {
                                            const selected = city.id == branch.city_id ? 'selected' : '';
                                            citySelect.innerHTML += `<option value="${city.id}" ${selected}>${city.name}</option>`;
                                        });
                                    }
                                });
                        }
                    });
            }
            
            // Show modal
            new bootstrap.Modal(document.getElementById('editBranchModal')).show();
        }
    </script>
@endsection
