@extends('layout.layout')
@section('content')
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">Designation / Roles </h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Role Masters</a></li>
                                <li class="breadcrumb-item active">Designation / Roles</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Add Designation / Roles</h4>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('designation.store') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="mb-3">
                                            <label for="designation_name" class="form-label">Designation/Role Name</label>
                                            <input type="text" class="form-control" id="designation_name"
                                                name="designation_name" placeholder="Enter designation name"
                                                value="{{ old('designation_name') }}" required>
                                            @error('designation_name')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3">
                                            <label for="authorities" class="form-label">Authorities <i
                                                    class="ri-information-line" data-bs-toggle="tooltip"
                                                    data-bs-placement="top" data-bs-html="true"
                                                    title="For highest authority admin enter 1 - admin can manage upper levels (2,3,4,etc).<br><br>For lower level subadmin/branch manager enter 2 - subadmin can manage upper levels (3,4,etc).<br><br>For branch staff enter 3 - staff can manage upper levels (4,5,etc).<br><br>For RO enter 99."
                                                    style="font-size: 15px;"></i></label>
                                            <input type="number" class="form-control" id="authorities" name="authorities"
                                                placeholder="Enter authorities level" value="{{ old('authorities') }}">
                                            @error('authorities')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="hstack gap-2 justify-content-end">
                                            <button type="submit" class="btn btn-primary">SAVE</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title mb-0">Designations/Role List</h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive table-card">
                                <table class="table align-middle table-nowrap table-striped-columns mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th width="5%">Sr No</th>
                                            <th width="45%">Designation/Role Name</th>
                                            <th width="15%">Authorities</th>
                                            <th width="15%">Status</th>
                                            <th width="20%">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($designations as $designation)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $designation->name }}</td>
                                                <td>{{ $designation->authorities ?? 'N/A' }}</td>
                                                <td>
                                                    <span
                                                        class="badge bg-{{ $designation->status ? 'success' : 'danger' }}">
                                                        {{ $designation->status ? 'Active' : 'Inactive' }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <form method="POST"
                                                        action="{{ route('designation.toggle-status', $designation->id) }}"
                                                        style="display:inline">
                                                        @csrf
                                                        @method('PATCH')
                                                        <button type="submit"
                                                            class="btn btn-sm btn-{{ $designation->status ? 'warning' : 'success' }}">
                                                            {{ $designation->status ? 'Deactivate' : 'Activate' }}
                                                        </button>
                                                    </form>
                                                    <button class="btn btn-sm btn-primary"
                                                        onclick="editDesignation({{ $designation->id }}, '{{ $designation->name }}', {{ $designation->authorities ?? 'null' }})">Edit</button>
                                                    <form method="POST"
                                                        action="{{ route('designation.destroy', $designation->id) }}"
                                                        style="display:inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                            onclick="return confirm('Are you sure?')">Delete</button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" class="text-center">No designations found</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Edit Modal -->
            <div class="modal fade" id="editModal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Edit Designation/Role</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <form id="editForm" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label for="edit_designation_name" class="form-label">Designation/Role Name</label>
                                    <input type="text" class="form-control" id="edit_designation_name"
                                        name="designation_name" required>
                                </div>
                                <div class="mb-3">
                                    <label for="edit_authorities" class="form-label">Authorities</label>
                                    <input type="number" class="form-control" id="edit_authorities" name="authorities"
                                        placeholder="Enter authorities level">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <script>
        function editDesignation(id, name, authorities) {
            document.getElementById('edit_designation_name').value = name;
            document.getElementById('edit_authorities').value = authorities || '';
            document.getElementById('editForm').action = '/masters/user-role/designation/' + id;
            new bootstrap.Modal(document.getElementById('editModal')).show();
        }
    </script>
@endsection
