@extends('layout.layout')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0">Application Settings</h4>
                    </div>
                </div>
            </div>

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="{{ route('settings.store') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label for="support_number1" class="form-label">Support Number 1</label>
                                            <input type="text"
                                                class="form-control @error('support_number1') is-invalid @enderror"
                                                id="support_number1" name="support_number1"
                                                value="{{ old('support_number1', $setting->support_number1) }}">
                                            @error('support_number1')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label for="support_number2" class="form-label">Support Number 2</label>
                                            <input type="text"
                                                class="form-control @error('support_number2') is-invalid @enderror"
                                                id="support_number2" name="support_number2"
                                                value="{{ old('support_number2', $setting->support_number2) }}">
                                            @error('support_number2')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label for="maintenance_mode" class="form-label">App Maintenance Mode</label>
                                            <select class="form-select @error('maintenance_mode') is-invalid @enderror"
                                                id="maintenance_mode" name="maintenance_mode">
                                                <option value="0"
                                                    {{ old('maintenance_mode', $setting->maintenance_mode) == 0 ? 'selected' : '' }}>
                                                    Disabled</option>
                                                <option value="1"
                                                    {{ old('maintenance_mode', $setting->maintenance_mode) == 1 ? 'selected' : '' }}>
                                                    Enabled</option>
                                            </select>
                                            @error('maintenance_mode')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    {{-- <div class="col-6">
                                    <div class="mb-3">
                                        <label for="status3" class="form-label">Status 3</label>
                                        <input type="text" class="form-control @error('status3') is-invalid @enderror" 
                                               id="status3" name="status3" value="{{ old('status3', $setting->status3) }}">
                                        @error('status3')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="mb-3">
                                        <label for="status4" class="form-label">Status 4</label>
                                        <input type="text" class="form-control @error('status4') is-invalid @enderror" 
                                               id="status4" name="status4" value="{{ old('status4', $setting->status4) }}">
                                        @error('status4')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div> --}}

                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label for="maintenance_mode_web" class="form-label">Web Maintenance
                                                Mode (all roles except admin)</label>
                                            <select class="form-select @error('maintenance_mode_web') is-invalid @enderror"
                                                id="maintenance_mode_web" name="maintenance_mode_web">
                                                <option value="0"
                                                    {{ old('maintenance_mode_web', $setting->maintenance_mode_web) == 0 ? 'selected' : '' }}>
                                                    Disabled</option>
                                                <option value="1"
                                                    {{ old('maintenance_mode_web', $setting->maintenance_mode_web) == 1 ? 'selected' : '' }}>
                                                    Enabled</option>
                                            </select>
                                            @error('maintenance_mode_web')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label for="version" class="form-label">Version</label>
                                            <input type="text"
                                                class="form-control @error('version') is-invalid @enderror" id="version"
                                                name="version" value="{{ old('version', $setting->version) }}">
                                            @error('version')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label for="logs" class="form-label">Api Logs (DB Logs)</label>
                                            <select class="form-select @error('logs') is-invalid @enderror" id="logs"
                                                name="logs">
                                                <option value="0"
                                                    {{ old('logs', $setting->logs) == 0 ? 'selected' : '' }}>Disabled
                                                </option>
                                                <option value="1"
                                                    {{ old('logs', $setting->logs) == 1 ? 'selected' : '' }}>Enabled
                                                </option>
                                            </select>
                                            @error('logs')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary">Update Settings</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
