@extends('layout.layout')

@section('content')
<div class="page-content">
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Form Field Details</h5>
                    <div>
                        <a href="{{ route('form-fields.edit', $formField) }}" class="btn btn-warning btn-sm">Edit</a>
                        <a href="{{ route('form-fields.index') }}" class="btn btn-secondary btn-sm">Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="30%">Field Name:</th>
                                    <td>{{ $formField->field_key }}</td>
                                </tr>
                                <tr>
                                    <th>Field Label:</th>
                                    <td>{{ $formField->field_label }}</td>
                                </tr>
                                <tr>
                                    <th>Field Type:</th>
                                    <td>{{ ucfirst($formField->field_type) }}</td>
                                </tr>
                                <tr>
                                    <th>Status:</th>
                                    <td>
                                        <span class="badge badge-{{ $formField->status ? 'success' : 'danger' }}">
                                            {{ $formField->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($formField->options->count() > 0)
                    <div class="mt-4">
                        <h6>Field Options</h6>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Label</th>
                                        <th>Value</th>
                                        <th>Sort Order</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($formField->options->sortBy('sort_order') as $option)
                                    <tr>
                                        <td>{{ $option->option_label }}</td>
                                        <td>{{ $option->option_value }}</td>
                                        <td>{{ $option->sort_order }}</td>
                                        <td>
                                            <span class="badge badge-{{ $option->status ? 'success' : 'danger' }}">
                                                {{ $option->status ? 'Active' : 'Inactive' }}
                                            </span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
</div>
@endsection