@extends('layout.layout')
@section('content')
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
* {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}
.modern-table {
    background: white;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    border: none;
}
.modern-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}
.modern-table thead th {
    color: white;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    padding: 20px 16px;
    border: none;
}
.modern-table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #f1f5f9;
}
.modern-table tbody tr:hover {
    background: #f8fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}
.modern-table tbody td {
    padding: 16px;
    vertical-align: middle;
    border: none;
    font-size: 14px;
    color: #475569;
}
.option-value {
    font-weight: 600;
    color: #1e293b;
    font-size: 15px;
}
.child-option {
    color: #64748b;
    font-weight: 500;
    padding-left: 24px;
}
.modern-badge {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}
.action-group {
    display: flex;
    gap: 6px;
    align-items: center;
}
.action-btn {
    padding: 8px 12px;
    border-radius: 8px;
    font-size: 12px;
    font-weight: 500;
    border: none;
    transition: all 0.2s ease;
    text-decoration: none;
}
.action-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}
.header-section {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    border-radius: 16px;
    padding: 24px;
    margin-bottom: 24px;
    border: 1px solid #e2e8f0;
}
.page-title {
    font-size: 28px;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}
.page-subtitle {
    color: #64748b;
    font-size: 16px;
    margin: 4px 0 0 0;
}
.add-btn {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 12px 24px;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    border: none;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}
.add-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
    color: white;
}
.btn-secondary {
    background: #f8fafc;
    border: 2px solid #e2e8f0;
    color: #64748b;
    padding: 10px 24px;
    border-radius: 12px;
    font-weight: 500;
    transition: all 0.3s ease;
}
.btn-secondary:hover {
    background: #e2e8f0;
    border-color: #cbd5e1;
    color: #475569;
}
.priority-badge {
    width: 32px;
    height: 32px;
    background: linear-gradient(135deg, #e2e8f0 0%, #cbd5e1 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    color: #475569;
    font-size: 12px;
}
.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: #64748b;
}
.empty-icon {
    font-size: 64px;
    color: #cbd5e1;
    margin-bottom: 16px;
}
.child-row {
    background: #f8fafc !important;
}
</style>

<div class="page-content">
    <div class="container-fluid">
        <div class="header-section">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="page-title">Field Options</h1>
                    <p class="page-subtitle">Manage options for "{{ $formField->field_label }}"</p>
                </div>
                <div class="d-flex gap-2">
                    <a href="{{ route('form-fields.options.create', $formField) }}" class="add-btn">
                        <i class="fas fa-plus me-2"></i>Add Option
                    </a>
                    <a href="{{ route('form-fields.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to Fields
                    </a>
                </div>
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show border-0 shadow-sm mb-4" style="border-radius: 12px;">
                <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <div class="modern-table">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th style="width: 80px;">Priority</th>
                        <th>Option Value</th>
                        <th>Master Option</th>
                        <th style="width: 120px;">Status</th>
                        <th style="width: 160px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($options as $option)
                        <tr>
                            <td>
                                <div class="priority-badge">{{ $option->priority }}</div>
                            </td>
                            <td>
                                <div class="option-value">{{ $option->option_value }}</div>
                            </td>
                            <td>
                                @if($option->parent)
                                    <span class="text-primary" style="font-weight: 500;">
                                        <i class="fas fa-link me-1"></i>
                                        {{ $option->parent->option_value }}
                                    </span>
                                @else
                                    <span class="text-muted">—</span>
                                @endif
                            </td>
                            <td>
                                <span class="modern-badge bg-{{ $option->status ? 'success' : 'danger' }} text-white">
                                    <i class="fas fa-{{ $option->status ? 'check' : 'times' }} me-1"></i>
                                    {{ $option->status ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td>
                                <div class="action-group">
                                    <a href="{{ route('form-fields.options.edit', [$formField, $option]) }}" class="action-btn btn-primary">
                                        <i class="fas fa-edit me-1"></i>Edit
                                    </a>
                                    <form method="POST" action="{{ route('form-fields.options.destroy', [$formField, $option]) }}" style="display:inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="action-btn btn-danger" onclick="return confirm('Are you sure you want to delete this option?')">
                                            <i class="fas fa-trash me-1"></i>Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @if($option->children && $option->children->count() > 0)
                            @foreach($option->children as $child)
                                <tr class="child-row">
                                    <td>
                                        <div class="priority-badge" style="background: linear-gradient(135deg, #ddd6fe 0%, #c4b5fd 100%); color: #7c3aed;">
                                            {{ $child->priority }}
                                        </div>
                                    </td>
                                    <td>
                                        <div class="child-option">
                                            <i class="ri-corner-down-right-line me-2 text-muted"></i>
                                            {{ $child->option_value }}
                                        </div>
                                    </td>
                                    <td>
                                        <span class="text-info" style="font-weight: 500;">
                                            <i class="fas fa-arrow-up me-1"></i>
                                            {{ $option->option_value }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="modern-badge bg-{{ $child->status ? 'success' : 'danger' }} text-white">
                                            <i class="fas fa-{{ $child->status ? 'check' : 'times' }} me-1"></i>
                                            {{ $child->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="action-group">
                                            <a href="{{ route('form-fields.options.edit', [$formField, $child]) }}" class="action-btn btn-primary">
                                                <i class="fas fa-edit me-1"></i>Edit
                                            </a>
                                            <form method="POST" action="{{ route('form-fields.options.destroy', [$formField, $child]) }}" style="display:inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="action-btn btn-danger" onclick="return confirm('Are you sure you want to delete this option?')">
                                                    <i class="fas fa-trash me-1"></i>Delete
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @endif
                    @empty
                        <tr>
                            <td colspan="5">
                                <div class="empty-state">
                                    <div class="empty-icon">
                                        <i class="fas fa-list-ul"></i>
                                    </div>
                                    <h5 style="color: #64748b; font-weight: 600;">No options found</h5>
                                    <p>Get started by creating your first option</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection