@extends('layout.layout')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">Edit Lead</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Lead Management</a></li>
                                <li class="breadcrumb-item active">Edit Lead</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Lead Information</h4>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('lead.update', $applicant->id) }}" method="POST" id="leadForm">
                                @csrf
                                @method('PUT')

                                <!-- Basic Information -->
                                <h1 class="mt-1">Applicant Details</h1>
                                <section id="applicant_section"
                                    style="border-bottom: 2px dashed #7c7f90; padding-bottom: 50px;">
                                    <h4 class="mt-3">Basic Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="segment" class="form-label">Segment</label>
                                                <select class="form-control" id="segment" name="segment">
                                                    <option value="">Select Segment</option>
                                                    @if (isset($dropdownFields['segment']))
                                                        @foreach ($dropdownFields['segment']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ $applicant->segment == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="loan_type" class="form-label">Loan Type</label>
                                                <select class="form-control" id="loan_type" name="loan_type">
                                                    <option value="">Select Loan Type</option>
                                                    @if (isset($dropdownFields['loan_type']))
                                                        @foreach ($dropdownFields['loan_type']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ $applicant->loan_type == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="customer_type" class="form-label">Customer Type</label>
                                                <select class="form-control" id="customer_type" name="customer_type">
                                                    <option value="">Select Type</option>
                                                    @if (isset($dropdownFields['customer_type']))
                                                        @foreach ($dropdownFields['customer_type']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ $applicant->customer_type == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_first_name" class="form-label">First Name <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" class="form-control" id="applicant_first_name"
                                                    name="applicant_first_name" value="{{ $applicant->applicant_first_name ?? '' }}">
                                                @error('applicant_first_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_middle_name" class="form-label">Middle Name</label>
                                                <input type="text" class="form-control" id="applicant_middle_name"
                                                    name="applicant_middle_name"
                                                    value="{{ $applicant->applicant_middle_name ?? '' }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_last_name" class="form-label">Last Name <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" class="form-control" id="applicant_last_name"
                                                    name="applicant_last_name" value="{{ $applicant->applicant_last_name ?? '' }}">
                                                @error('applicant_last_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="father_name" class="form-label">Father Name <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" class="form-control" id="father_name"
                                                    name="father_name" value="{{ $applicant->father_name ?? '' }}">
                                                @error('father_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="caste" class="form-label">Caste</label>
                                                <select class="form-control" id="caste" name="caste">
                                                    <option value="">Select Caste</option>
                                                    @if (isset($dropdownFields['caste']))
                                                        @foreach ($dropdownFields['caste']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ $applicant->caste == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="dob" class="form-label">DOB</label>
                                                <input type="date" class="form-control" id="dob" name="dob"
                                                    value="{{ $applicant->dob ?? '' }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="age" class="form-label">Age</label>
                                                <input type="number" class="form-control" id="age" name="age"
                                                    value="{{ $applicant->age ?? '' }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="gender" class="form-label">Gender</label>
                                                <select class="form-control" id="gender" name="gender">
                                                    <option value="">Select Gender</option>
                                                    @if (isset($dropdownFields['gender']))
                                                        @foreach ($dropdownFields['gender']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ $applicant->gender == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Contact Information -->
                                    <h4 class="mt-4">Contact Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="contact_number" class="form-label">Contact Number <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" class="form-control" id="contact_number"
                                                    name="contact_number" value="{{ $applicant->contact_number ?? '' }}">
                                                @error('contact_number')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="contact_verified" class="form-label">Contact Verified</label>
                                                <select class="form-control" id="contact_verified"
                                                    name="contact_verified">
                                                    <option value="0"
                                                        {{ $applicant->contact_verified == '0' ? 'selected' : '' }}>No</option>
                                                    <option value="1"
                                                        {{ $applicant->contact_verified == '1' ? 'selected' : '' }}>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="email" class="form-label">Email</label>
                                                <input type="email" class="form-control" id="email" name="email"
                                                    value="{{ $applicant->email ?? '' }}">
                                            </div>
                                        </div>
                                    </div>
                                </section>

                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Update Lead</button>
                                        <a href="{{ route('lead.assign') }}" class="btn btn-secondary">Cancel</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection