@extends('layout.layout')
@section('content')

    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">Assign Lead</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Lead Management</a></li>
                                <li class="breadcrumb-item active">Assign Lead</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    @if (request()->hasAny(['status', 'branch_id', 'created_by', 'assign_to', 'start_date', 'end_date', 'search']) &&
                            (request()->filled('status') ||
                                request()->filled('branch_id') ||
                                request()->filled('created_by') ||
                                request()->filled('assign_to') ||
                                request()->filled('start_date') ||
                                request()->filled('end_date') ||
                                request()->filled('search')))
                        <div class="row">
                            <div class="col-xl-12 col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="d-flex">
                                            <div class="flex-grow-1">
                                                <h5 class="fs-16">Applied Filters</h5>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <a href="{{ route('lead.assign') }}" class="text-decoration-underline">CLEAR
                                                    ALL</a>
                                            </div>
                                        </div>
                                        <div class="filter-choices-input">
                                            <div class="choices" data-type="text">
                                                <div class="choices__inner">
                                                    <div class="choices__list choices__list--multiple" id="applied-filters">
                                                        @if (request('search'))
                                                            <div class="choices__item choices__item--selectable">
                                                                Search: {{ request('search') }}
                                                                <button type="button" class="choices__button"
                                                                    onclick="removeFilter('search')">Remove</button>
                                                            </div>
                                                        @endif
                                                        @if (request('status'))
                                                            @foreach ((array) request('status') as $statusId)
                                                                @php
                                                                    $statusNames = [
                                                                        '1' => 'New',
                                                                        '2' => 'RO Assigned',
                                                                        '3' => 'RO Verified',
                                                                        '4' => 'Branch Review',
                                                                         '5' => 'Branch approved',
                                                                        '6' => 'Bank wise approve',
                                                                        '7' => 'Final Lead source',
                                                                        '90' => 'Cancelled',
                                                                        '91' => 'Other',
                                                                    ];
                                                                @endphp
                                                                <div class="choices__item choices__item--selectable">
                                                                    Status: {{ $statusNames[$statusId] ?? $statusId }}
                                                                    <button type="button" class="choices__button"
                                                                        onclick="removeArrayFilter('status', '{{ $statusId }}')">Remove</button>
                                                                </div>
                                                            @endforeach
                                                        @endif
                                                        @if (request('branch_id'))
                                                            @foreach ((array) request('branch_id') as $branchId)
                                                                @php $branch = $branches->find($branchId) @endphp
                                                                @if ($branch)
                                                                    <div class="choices__item choices__item--selectable">
                                                                        Branch: {{ $branch->branch_name }}
                                                                        <button type="button" class="choices__button"
                                                                            onclick="removeArrayFilter('branch_id', '{{ $branchId }}')">Remove</button>
                                                                    </div>
                                                                @endif
                                                            @endforeach
                                                        @endif
                                                        @if (request('created_by'))
                                                            @foreach ((array) request('created_by') as $userId)
                                                                @php $user = $users->find($userId) @endphp
                                                                @if ($user)
                                                                    <div class="choices__item choices__item--selectable">
                                                                        Created By: {{ $user->name }}
                                                                        <button type="button" class="choices__button"
                                                                            onclick="removeArrayFilter('created_by', '{{ $userId }}')">Remove</button>
                                                                    </div>
                                                                @endif
                                                            @endforeach
                                                        @endif
                                                        @if (request('assign_to'))
                                                            @foreach ((array) request('assign_to') as $assignId)
                                                                @php $assignUser = $roUsers->find($assignId) @endphp
                                                                @if ($assignUser)
                                                                    <div class="choices__item choices__item--selectable">
                                                                        Assigned To: {{ $assignUser->name }}
                                                                        <button type="button" class="choices__button"
                                                                            onclick="removeArrayFilter('assign_to', '{{ $assignId }}')">Remove</button>
                                                                    </div>
                                                                @endif
                                                            @endforeach
                                                        @endif
                                                        @if (request('start_date') || request('end_date'))
                                                            <div class="choices__item choices__item--selectable">
                                                                Date:
                                                                {{ request('start_date') ? request('start_date') : '' }}{{ request('start_date') && request('end_date') ? ' to ' : '' }}{{ request('end_date') ? request('end_date') : '' }}
                                                                <button type="button" class="choices__button"
                                                                    onclick="removeDateFilter()">Remove</button>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title mb-0">Lead List</h4>

                            <button type="button" class="btn btn-info" data-bs-toggle="offcanvas" href="#filterModal">
                                <i class="ri-filter-3-line align-bottom me-1"></i>
                                Filters
                            </button>
                        </div>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-nowrap align-middle mb-0" style="font-size: 12px;">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Applicant Name</th>
                                            <th scope="col">Contact Number</th>
                                            <th scope="col">Branch</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Created By</th>
                                            <th scope="col">Assigned To</th>
                                            <th scope="col">Created Date</th>
                                            <th scope="col">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($applicants as $key => $applicant)
                                            <tr>
                                                <td>{{ $key + 1 }}</td>
                                                <td>{{ $applicant->applicant_first_name }}
                                                    {{ $applicant->applicant_last_name }}</td>
                                                <td>{{ $applicant->contact_number }}</td>
                                                <td>{{ $applicant->branch->branch_name ?? 'N/A' }}</td>
                                                <td>
                                                    @switch($applicant->status)
                                                        @case(1)
                                                            <span class="badge bg-primary">New</span>
                                                        @break

                                                        @case(2)
                                                            <span class="badge bg-info">RO Assigned</span>
                                                        @break

                                                        @case(3)
                                                            <span class="badge bg-warning">RO Verified</span>
                                                        @break

                                                        @case(4)
                                                            <span class="badge bg-secondary">Branch Review</span>
                                                        @break

                                                        @case(5)
                                                            <span class="badge bg-secondary">Branch Approved</span>
                                                        @break

                                                        @case(6)
                                                            <span class="badge bg-success">Bank wise approve</span>
                                                        @break

                                                        @case(7)
                                                            <span class="badge bg-dark">Final Lead source</span>
                                                        @break

                                                        @case(90)
                                                            <span class="badge bg-danger">Cancelled</span>
                                                        @break

                                                        @case(91)
                                                            <span class="badge bg-light text-dark">Other</span>
                                                        @break

                                                        @default
                                                            <span class="badge bg-light text-dark">Unknown</span>
                                                    @endswitch
                                                </td>
                                                <td>{{ $applicant->creator->name ?? 'N/A' }}</td>
                                                <td>{{ $applicant->assignedTo->name ?? 'Not Assigned' }}</td>
                                                <td>{{ $applicant->created_at->format('d M Y h:i A') }}</td>

                                                <td>
                                                    <button class="btn btn-sm btn-info"
                                                        onclick="viewLead({{ $applicant->id }})">View</button>
                                                    @if (!$applicant->assign_to)
                                                        <button class="btn btn-sm btn-success"
                                                            onclick="assignLead({{ $applicant->id }})">Assign</button>
                                                    @endif
                                                    <form method="POST"
                                                        action="{{ route('lead.destroy', $applicant->id) }}"
                                                        style="display:inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                            onclick="return confirm('Are you sure?')">Delete</button>
                                                    </form>
                                                    <button class="btn btn-sm btn-secondary"
                                                        onclick="toggleActions({{ $applicant->id }})">⋯</button>
                                                    <div id="actions-{{ $applicant->id }}" class="d-none mt-1">

                                                        @if ($applicant->status == 3)
                                                            <a href="{{ route('lead.branch-verify', $applicant->id) }}"
                                                                class="btn btn-sm btn-success me-1"
                                                                onclick="return confirm('Are you sure you want to start review this lead?')">Branch
                                                                Verify</a>
                                                        @endif

                                                        {{-- <button class="btn btn-sm btn-info me-1"
                                                            onclick="viewHistory({{ $applicant->id }})">History</button> --}}
                                                        {{-- <button class="btn btn-sm btn-warning me-1"
                                                            onclick="duplicateLead({{ $applicant->id }})">Duplicate</button>
                                                        <button class="btn btn-sm btn-dark"
                                                            onclick="exportLead({{ $applicant->id }})">Export</button> --}}
                                                    </div>
                                                </td>
                                            </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="10" class="text-center">No leads found</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                                {{ $applicants->links('pagination::bootstrap-4') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Assign Lead Modal -->
        <div class="modal fade" id="assignLeadModal" tabindex="-1" aria-labelledby="assignLeadModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="assignLeadModalLabel">Assign Applicant Lead</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form id="assignLeadForm">
                        <div class="modal-body">
                            <div id="assignAlert" class="alert" style="display: none;"></div>
                            @csrf
                            <input type="hidden" id="applicant_id" name="applicant_id">
                            <div class="mb-3">
                                <label for="branch_select" class="form-label">Select Branch</label>
                                <select class="form-control" id="branch_select" name="branch_id" required>
                                    <option value="">Select Branch</option>
                                    @foreach ($branches as $branch)
                                        <option value="{{ $branch->id }}">{{ $branch->branch_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="staff_select" class="form-label">Select RO Staff</label>
                                <select class="form-control" id="staff_select" name="assign_to" required>
                                    <option value="">Select Staff</option>
                                </select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Assign Lead</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


        <!-- Filter Modal -->
        <div class="offcanvas offcanvas-end" tabindex="-1" id="filterModal" aria-labelledby="offcanvasExampleLabel"
            aria-modal="true" role="dialog">
            <div class="offcanvas-header bg-light">
                <h5 class="offcanvas-title" id="offcanvasExampleLabel">Expenses Fliters</h5>
                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <!--end offcanvas-header-->
            <form action="{{ route('lead.assign') }}" method="GET" class="d-flex flex-column justify-content-end"
                style="height: 90%;">
                <div class="offcanvas-body">
                    <div class="mb-4">
                        <label for="date_from" class="form-label text-muted text-uppercase fw-semibold mb-3">Date
                            Range</label>
                        <div class="row g-2 align-items-center">
                            <div class="col-lg">
                                <input type="date" class="form-control" name="start_date" id="date_from"
                                    value="{{ request('start_date') }}" placeholder="From Date">
                            </div>
                            <div class="col-lg-auto">
                                To
                            </div>
                            <div class="col-lg">
                                <input type="date" class="form-control" name="end_date" id="date_to"
                                    value="{{ request('end_date') }}" placeholder="To Date">
                            </div>
                        </div>
                    </div>


                    <div class="mb-4">
                        <label for="date_from" class="form-label text-muted text-uppercase fw-semibold mb-3">Search by
                            applicant name OR number</label>
                        <div class="row g-2 align-items-center">
                            <div class="col-lg">
                                <input type="text" class="form-control" name="search" id="search"
                                    value="{{ request('search') }}" placeholder="Search by applicant name OR number">
                            </div>

                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="datepicker-range" class="form-label text-muted text-uppercase fw-semibold mb-3">Select
                            Lead Status</label>
                        <select class="js-example-basic-multiple" name="status[]" multiple="multiple"
                            data-placeholder="Select Status">
                            <option value="1" {{ in_array('1', (array) request('status', [])) ? 'selected' : '' }}>New
                            </option>
                            <option value="2" {{ in_array('2', (array) request('status', [])) ? 'selected' : '' }}>RO
                                Assigned</option>
                            <option value="3" {{ in_array('3', (array) request('status', [])) ? 'selected' : '' }}>RO
                                Verified</option>
                            <option value="4" {{ in_array('4', (array) request('status', [])) ? 'selected' : '' }}>Branch
                                Review</option>

                            <option value="5" {{ in_array('5', (array) request('status', [])) ? 'selected' : '' }}>Branch
                                Approved</option>

                            <option value="6" {{ in_array('6', (array) request('status', [])) ? 'selected' : '' }}>Bank
                                wise approve</option>
                            <option value="7" {{ in_array('7', (array) request('status', [])) ? 'selected' : '' }}>Final
                                Lead source</option>
                            <option value="90" {{ in_array('90', (array) request('status', [])) ? 'selected' : '' }}>
                                Cancelled</option>
                            <option value="91" {{ in_array('91', (array) request('status', [])) ? 'selected' : '' }}>Other
                            </option>
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="datepicker-range" class="form-label text-muted text-uppercase fw-semibold mb-3">Select
                            Branch</label>
                        <select class="js-example-basic-multiple" name="branch_id[]" multiple="multiple"
                            data-placeholder="Select Branch">
                            @foreach ($branches as $branch)
                                <option value="{{ $branch->id }}"
                                    {{ in_array($branch->id, (array) request('branch_id', [])) ? 'selected' : '' }}>
                                    {{ $branch->branch_name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="datepicker-range" class="form-label text-muted text-uppercase fw-semibold mb-3">Created
                            By</label>
                        <select class="js-example-basic-multiple" name="created_by[]" multiple="multiple"
                            data-placeholder="Select Created By">
                            @foreach ($users as $user)
                                <option value="{{ $user->id }}"
                                    {{ in_array($user->id, (array) request('created_by', [])) ? 'selected' : '' }}>
                                    {{ $user->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="datepicker-range" class="form-label text-muted text-uppercase fw-semibold mb-3">Assign
                            to</label>
                        <select class="js-example-basic-multiple" name="assign_to[]" multiple="multiple"
                            data-placeholder="Select Assign To">
                            @foreach ($roUsers as $ro)
                                <option value="{{ $ro->id }}"
                                    {{ in_array($ro->id, (array) request('assign_to', [])) ? 'selected' : '' }}>
                                    {{ $ro->name }}</option>
                            @endforeach
                        </select>
                    </div>


                </div>
                <!--end offcanvas-body-->
                <div class="offcanvas-footer border-top p-3 text-center hstack gap-2">
                    <button type="button" class="btn btn-light w-100" onclick="clearFilters()">Clear Filter</button>
                    <button type="submit" class="btn btn-success w-100">Apply Filters</button>
                </div>
                <!--end offcanvas-footer-->
            </form>
        </div>
        <!-- End Filter Modal -->






        <script src="{{ asset('assets/js/pages/lead-assign.js') }}"></script>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Filter removal functions
                window.removeFilter = function(filterName) {
                    const url = new URL(window.location);
                    url.searchParams.delete(filterName);
                    window.location.href = url.toString();
                };

                window.removeArrayFilter = function(filterName, value) {
                    const url = new URL(window.location);
                    const currentValues = url.searchParams.getAll(filterName + '[]');
                    url.searchParams.delete(filterName + '[]');

                    currentValues.forEach(val => {
                        if (val !== value) {
                            url.searchParams.append(filterName + '[]', val);
                        }
                    });

                    window.location.href = url.toString();
                };

                window.removeDateFilter = function() {
                    const url = new URL(window.location);
                    url.searchParams.delete('start_date');
                    url.searchParams.delete('end_date');
                    window.location.href = url.toString();
                };

                window.clearFilters = function() {
                    // Clear form fields only
                    document.getElementById('date_from').value = '';
                    document.getElementById('date_to').value = '';
                    document.getElementById('search').value = '';

                    // Clear all select2 dropdowns
                    $('.js-example-basic-multiple').val(null).trigger('change');
                };

                window.applyFilters = function() {
                    // Form will submit automatically
                };
            });
        </script>


    @endsection
