function assignLead(applicantId) {
    document.getElementById('applicant_id').value = applicantId;
    document.getElementById('staff_select').innerHTML = '<option value="">Select Staff</option>';
    new bootstrap.Modal(document.getElementById('assignLeadModal')).show();
}

function viewLead(applicantId) {
    window.location.href = `/masters/lead-management/view/${applicantId}`;
}

function editLead(applicantId) {
    window.location.href = `/masters/lead-management/edit/${applicantId}`;
}

function toggleActions(applicantId) {
    const actionsDiv = document.getElementById(`actions-${applicantId}`);
    actionsDiv.classList.toggle('d-none');
}

function viewHistory(applicantId) {
    console.log('View history for applicant:', applicantId);
}

function duplicateLead(applicantId) {
    console.log('Duplicate lead for applicant:', applicantId);
}

function exportLead(applicantId) {
    console.log('Export lead for applicant:', applicantId);
}

// Load staff based on branch selection
document.getElementById('branch_select').addEventListener('change', function () {
    const branchId = this.value;
    const staffSelect = document.getElementById('staff_select');

    if (branchId) {
        fetch(`/api/branch-staff/${branchId}`)
            .then(response => response.json())
            .then(data => {
                staffSelect.innerHTML = '<option value="">Select Staff</option>';
                data.forEach(staff => {
                    staffSelect.innerHTML +=
                        `<option value="${staff.id}">${staff.name}</option>`;
                });
            })
            .catch(error => {
                console.error('Error:', error);
                staffSelect.innerHTML = '<option value="">Error loading staff</option>';
            });
    } else {
        staffSelect.innerHTML = '<option value="">Select Staff</option>';
    }
});

// Handle form submission
document.getElementById('assignLeadForm').addEventListener('submit', function (e) {
    e.preventDefault();

    const formData = new FormData(this);

    fetch('/masters/lead-management/assign-lead-update', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute(
                'content')
        }
    })
        .then(response => response.json())
        .then(data => {
            const alertDiv = document.getElementById('assignAlert');
            if (data.success) {
                alertDiv.className = 'alert alert-success';
                alertDiv.textContent = 'Lead assigned successfully!';
                alertDiv.style.display = 'block';
                setTimeout(() => {
                    bootstrap.Modal.getInstance(document.getElementById('assignLeadModal')).hide();
                    location.reload();
                }, 1500);
            } else {
                alertDiv.className = 'alert alert-danger';
                alertDiv.textContent = 'Error: ' + data.message;
                alertDiv.style.display = 'block';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            const alertDiv = document.getElementById('assignAlert');
            alertDiv.className = 'alert alert-danger';
            alertDiv.textContent = 'An error occurred while assigning the lead.';
            alertDiv.style.display = 'block';
        });
});