<?php

namespace Database\Seeders;

use App\Models\Department;
use Illuminate\Database\Seeder;

class DepartmentSeeder extends Seeder
{
    public function run(): void
    {
        $departments = [
            ['name' => 'Human Resources', 'status' => true],
            ['name' => 'Finance', 'status' => true],
            ['name' => 'Information Technology', 'status' => true],
            ['name' => 'Marketing', 'status' => true],
            ['name' => 'Operations', 'status' => true],
        ];

        foreach ($departments as $department) {
            Department::updateOrCreate(
                ['name' => $department['name']],
                $department
            );
        }
    }
}
