<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\City;

class CitySeeder extends Seeder
{
    public function run(): void
    {
        $now = now();
        
        $cities = [
            // Andhra Pradesh (1) - Districts 1-12
            ['name' => 'Anantapur', 'state_id' => 1, 'district_id' => 1],
            ['name' => 'Hindupur', 'state_id' => 1, 'district_id' => 1],
            ['name' => 'Guntakal', 'state_id' => 1, 'district_id' => 1],
            ['name' => 'Dharmavaram', 'state_id' => 1, 'district_id' => 1],
            ['name' => 'Tadipatri', 'state_id' => 1, 'district_id' => 1],
            ['name' => 'Chittoor', 'state_id' => 1, 'district_id' => 2],
            ['name' => 'Tirupati', 'state_id' => 1, 'district_id' => 2],
            ['name' => 'Madanapalle', 'state_id' => 1, 'district_id' => 2],
            ['name' => 'Rajahmundry', 'state_id' => 1, 'district_id' => 3],
            ['name' => 'Kakinada', 'state_id' => 1, 'district_id' => 3],
            ['name' => 'Guntur', 'state_id' => 1, 'district_id' => 4],
            ['name' => 'Tenali', 'state_id' => 1, 'district_id' => 4],
            ['name' => 'Narasaraopet', 'state_id' => 1, 'district_id' => 4],
            ['name' => 'Mangalagiri', 'state_id' => 1, 'district_id' => 4],
            ['name' => 'Chilakaluripet', 'state_id' => 1, 'district_id' => 4],
            ['name' => 'Vijayawada', 'state_id' => 1, 'district_id' => 5],
            ['name' => 'Machilipatnam', 'state_id' => 1, 'district_id' => 5],
            ['name' => 'Gudivada', 'state_id' => 1, 'district_id' => 5],
            ['name' => 'Kurnool', 'state_id' => 1, 'district_id' => 6],
            ['name' => 'Nandyal', 'state_id' => 1, 'district_id' => 6],
            ['name' => 'Adoni', 'state_id' => 1, 'district_id' => 6],
            ['name' => 'Ongole', 'state_id' => 1, 'district_id' => 7],
            ['name' => 'Chirala', 'state_id' => 1, 'district_id' => 7],
            ['name' => 'Srikakulam', 'state_id' => 1, 'district_id' => 8],
            ['name' => 'Narasannapeta', 'state_id' => 1, 'district_id' => 8],
            ['name' => 'Visakhapatnam', 'state_id' => 1, 'district_id' => 9],
            ['name' => 'Anakapalle', 'state_id' => 1, 'district_id' => 9],
            ['name' => 'Vizianagaram', 'state_id' => 1, 'district_id' => 10],
            ['name' => 'Parvathipuram', 'state_id' => 1, 'district_id' => 10],
            ['name' => 'Eluru', 'state_id' => 1, 'district_id' => 11],
            ['name' => 'Bhimavaram', 'state_id' => 1, 'district_id' => 11],
            ['name' => 'Kadapa', 'state_id' => 1, 'district_id' => 12],
            ['name' => 'Proddatur', 'state_id' => 1, 'district_id' => 12],

            // Arunachal Pradesh (2) - Districts 13-30
            ['name' => 'Hawai', 'state_id' => 2, 'district_id' => 13],
            ['name' => 'Changlang', 'state_id' => 2, 'district_id' => 14],
            ['name' => 'Anini', 'state_id' => 2, 'district_id' => 15],
            ['name' => 'Seppa', 'state_id' => 2, 'district_id' => 16],
            ['name' => 'Pasighat', 'state_id' => 2, 'district_id' => 17],
            ['name' => 'Roing', 'state_id' => 2, 'district_id' => 18],
            ['name' => 'Jamin', 'state_id' => 2, 'district_id' => 19],
            ['name' => 'Koloriang', 'state_id' => 2, 'district_id' => 20],
            ['name' => 'Basar', 'state_id' => 2, 'district_id' => 21],
            ['name' => 'Tezu', 'state_id' => 2, 'district_id' => 22],
            ['name' => 'Roing', 'state_id' => 2, 'district_id' => 23],
            ['name' => 'Likabali', 'state_id' => 2, 'district_id' => 24],
            ['name' => 'Ziro', 'state_id' => 2, 'district_id' => 25],
            ['name' => 'Namsai', 'state_id' => 2, 'district_id' => 26],
            ['name' => 'Itanagar', 'state_id' => 2, 'district_id' => 27],
            ['name' => 'Naharlagun', 'state_id' => 2, 'district_id' => 27],
            ['name' => 'Tawang', 'state_id' => 2, 'district_id' => 28],
            ['name' => 'Bomdila', 'state_id' => 2, 'district_id' => 29],
            ['name' => 'Along', 'state_id' => 2, 'district_id' => 30],
            ['name' => 'Daporijo', 'state_id' => 2, 'district_id' => 30],

            // Assam (3) - Districts 31-46
            ['name' => 'Mushalpur', 'state_id' => 3, 'district_id' => 31],
            ['name' => 'Barpeta', 'state_id' => 3, 'district_id' => 32],
            ['name' => 'Barpeta Road', 'state_id' => 3, 'district_id' => 32],
            ['name' => 'Biswanath Chariali', 'state_id' => 3, 'district_id' => 33],
            ['name' => 'Bongaigaon', 'state_id' => 3, 'district_id' => 34],
            ['name' => 'Silchar', 'state_id' => 3, 'district_id' => 35],
            ['name' => 'Karimganj', 'state_id' => 3, 'district_id' => 35],
            ['name' => 'Kajalgaon', 'state_id' => 3, 'district_id' => 36],
            ['name' => 'Mangaldoi', 'state_id' => 3, 'district_id' => 37],
            ['name' => 'Dhemaji', 'state_id' => 3, 'district_id' => 38],
            ['name' => 'Dhubri', 'state_id' => 3, 'district_id' => 39],
            ['name' => 'Dibrugarh', 'state_id' => 3, 'district_id' => 40],
            ['name' => 'Tinsukia', 'state_id' => 3, 'district_id' => 40],
            ['name' => 'Goalpara', 'state_id' => 3, 'district_id' => 41],
            ['name' => 'Golaghat', 'state_id' => 3, 'district_id' => 42],
            ['name' => 'Hailakandi', 'state_id' => 3, 'district_id' => 43],
            ['name' => 'Jorhat', 'state_id' => 3, 'district_id' => 44],
            ['name' => 'Sivasagar', 'state_id' => 3, 'district_id' => 44],
            ['name' => 'Rangia', 'state_id' => 3, 'district_id' => 45],
            ['name' => 'Guwahati', 'state_id' => 3, 'district_id' => 46],
            ['name' => 'North Lakhimpur', 'state_id' => 3, 'district_id' => 46],
            ['name' => 'Tezpur', 'state_id' => 3, 'district_id' => 46],
            ['name' => 'Nagaon', 'state_id' => 3, 'district_id' => 46],
            ['name' => 'Diphu', 'state_id' => 3, 'district_id' => 46],
            ['name' => 'Nalbari', 'state_id' => 3, 'district_id' => 46],
            ['name' => 'Kokrajhar', 'state_id' => 3, 'district_id' => 46],

            // Bihar (4) - Districts 47-56
            ['name' => 'Araria', 'state_id' => 4, 'district_id' => 47],
            ['name' => 'Forbesganj', 'state_id' => 4, 'district_id' => 47],
            ['name' => 'Aurangabad', 'state_id' => 4, 'district_id' => 48],
            ['name' => 'Bhagalpur', 'state_id' => 4, 'district_id' => 49],
            ['name' => 'Darbhanga', 'state_id' => 4, 'district_id' => 50],
            ['name' => 'Madhubani', 'state_id' => 4, 'district_id' => 50],
            ['name' => 'Gaya', 'state_id' => 4, 'district_id' => 51],
            ['name' => 'Bodh Gaya', 'state_id' => 4, 'district_id' => 51],
            ['name' => 'Muzaffarpur', 'state_id' => 4, 'district_id' => 52],
            ['name' => 'Sitamarhi', 'state_id' => 4, 'district_id' => 52],
            ['name' => 'Bihar Sharif', 'state_id' => 4, 'district_id' => 53],
            ['name' => 'Rajgir', 'state_id' => 4, 'district_id' => 53],
            ['name' => 'Patna', 'state_id' => 4, 'district_id' => 54],
            ['name' => 'Danapur', 'state_id' => 4, 'district_id' => 54],
            ['name' => 'Purnia', 'state_id' => 4, 'district_id' => 55],
            ['name' => 'Kishanganj', 'state_id' => 4, 'district_id' => 55],
            ['name' => 'Sasaram', 'state_id' => 4, 'district_id' => 56],
            ['name' => 'Dehri', 'state_id' => 4, 'district_id' => 56],
            ['name' => 'Arrah', 'state_id' => 4, 'district_id' => 56],
            ['name' => 'Begusarai', 'state_id' => 4, 'district_id' => 54],
            ['name' => 'Katihar', 'state_id' => 4, 'district_id' => 55],
            ['name' => 'Munger', 'state_id' => 4, 'district_id' => 49],
            ['name' => 'Chhapra', 'state_id' => 4, 'district_id' => 56],
            ['name' => 'Saharsa', 'state_id' => 4, 'district_id' => 50],
            ['name' => 'Hajipur', 'state_id' => 4, 'district_id' => 52],
            ['name' => 'Siwan', 'state_id' => 4, 'district_id' => 56],
            ['name' => 'Motihari', 'state_id' => 4, 'district_id' => 52],
            ['name' => 'Nawada', 'state_id' => 4, 'district_id' => 51],
            ['name' => 'Bagaha', 'state_id' => 4, 'district_id' => 52],
            ['name' => 'Buxar', 'state_id' => 4, 'district_id' => 56],
            ['name' => 'Jamalpur', 'state_id' => 4, 'district_id' => 49],
            ['name' => 'Jehanabad', 'state_id' => 4, 'district_id' => 51],
            ['name' => 'Lakhisarai', 'state_id' => 4, 'district_id' => 49],
            ['name' => 'Sheikhpura', 'state_id' => 4, 'district_id' => 53],
            ['name' => 'Supaul', 'state_id' => 4, 'district_id' => 50],

            // Chhattisgarh (5) - Districts 57-61
            ['name' => 'Dongargarh', 'state_id' => 5, 'district_id' => 57],
            ['name' => 'Gunderdehi', 'state_id' => 5, 'district_id' => 58],
            ['name' => 'Bilaspur', 'state_id' => 5, 'district_id' => 59],
            ['name' => 'Korba', 'state_id' => 5, 'district_id' => 59],
            ['name' => 'Durg', 'state_id' => 5, 'district_id' => 60],
            ['name' => 'Bhilai', 'state_id' => 5, 'district_id' => 60],
            ['name' => 'Rajnandgaon', 'state_id' => 5, 'district_id' => 60],
            ['name' => 'Raipur', 'state_id' => 5, 'district_id' => 61],
            ['name' => 'Mahasamund', 'state_id' => 5, 'district_id' => 61],
            ['name' => 'Dhamtari', 'state_id' => 5, 'district_id' => 61],
            ['name' => 'Jagdalpur', 'state_id' => 5, 'district_id' => 61],
            ['name' => 'Raigarh', 'state_id' => 5, 'district_id' => 59],
            ['name' => 'Ambikapur', 'state_id' => 5, 'district_id' => 59],
            ['name' => 'Chirmiri', 'state_id' => 5, 'district_id' => 59],
            ['name' => 'Bhatapara', 'state_id' => 5, 'district_id' => 61],
            ['name' => 'Dalli-Rajhara', 'state_id' => 5, 'district_id' => 60],
            ['name' => 'Naila Janjgir', 'state_id' => 5, 'district_id' => 59],
            ['name' => 'Tilda Newra', 'state_id' => 5, 'district_id' => 61],
            ['name' => 'Mungeli', 'state_id' => 5, 'district_id' => 59],
            ['name' => 'Manendragarh', 'state_id' => 5, 'district_id' => 59],
            ['name' => 'Sakti', 'state_id' => 5, 'district_id' => 59],
            ['name' => 'Akaltara', 'state_id' => 5, 'district_id' => 59],

            // Goa (6) - Districts 62-63
            ['name' => 'Panaji', 'state_id' => 6, 'district_id' => 62],
            ['name' => 'Mapusa', 'state_id' => 6, 'district_id' => 62],
            ['name' => 'Bicholim', 'state_id' => 6, 'district_id' => 62],
            ['name' => 'Ponda', 'state_id' => 6, 'district_id' => 62],
            ['name' => 'Sanquelim', 'state_id' => 6, 'district_id' => 62],
            ['name' => 'Margao', 'state_id' => 6, 'district_id' => 63],
            ['name' => 'Vasco da Gama', 'state_id' => 6, 'district_id' => 63],
            ['name' => 'Curchorem', 'state_id' => 6, 'district_id' => 63],
            ['name' => 'Cuncolim', 'state_id' => 6, 'district_id' => 63],
            ['name' => 'Quepem', 'state_id' => 6, 'district_id' => 63],

            // Gujarat (7) - Districts 64-95
            ['name' => 'Ahmedabad', 'state_id' => 7, 'district_id' => 64],
            ['name' => 'Gandhinagar', 'state_id' => 7, 'district_id' => 76],
            ['name' => 'Surat', 'state_id' => 7, 'district_id' => 91],
            ['name' => 'Vadodara', 'state_id' => 7, 'district_id' => 94],
            ['name' => 'Rajkot', 'state_id' => 7, 'district_id' => 89],
            ['name' => 'Bhavnagar', 'state_id' => 7, 'district_id' => 70],
            ['name' => 'Jamnagar', 'state_id' => 7, 'district_id' => 78],
            ['name' => 'Junagadh', 'state_id' => 7, 'district_id' => 79],
            ['name' => 'Anand', 'state_id' => 7, 'district_id' => 66],
            ['name' => 'Navsari', 'state_id' => 7, 'district_id' => 86],
            ['name' => 'Morbi', 'state_id' => 7, 'district_id' => 84],
            ['name' => 'Nadiad', 'state_id' => 7, 'district_id' => 66],
            ['name' => 'Bharuch', 'state_id' => 7, 'district_id' => 69],
            ['name' => 'Mehsana', 'state_id' => 7, 'district_id' => 83],
            ['name' => 'Bhuj', 'state_id' => 7, 'district_id' => 81],
            ['name' => 'Porbandar', 'state_id' => 7, 'district_id' => 89],
            ['name' => 'Palanpur', 'state_id' => 7, 'district_id' => 68],
            ['name' => 'Valsad', 'state_id' => 7, 'district_id' => 95],
            ['name' => 'Vapi', 'state_id' => 7, 'district_id' => 95],
            ['name' => 'Gondal', 'state_id' => 7, 'district_id' => 89],
            ['name' => 'Veraval', 'state_id' => 7, 'district_id' => 77],
            ['name' => 'Godhra', 'state_id' => 7, 'district_id' => 87],
            ['name' => 'Patan', 'state_id' => 7, 'district_id' => 88],
            ['name' => 'Kalol', 'state_id' => 7, 'district_id' => 83],
            ['name' => 'Dahod', 'state_id' => 7, 'district_id' => 73],
            ['name' => 'Botad', 'state_id' => 7, 'district_id' => 71],
            ['name' => 'Amreli', 'state_id' => 7, 'district_id' => 65],
            ['name' => 'Deesa', 'state_id' => 7, 'district_id' => 68],
            ['name' => 'Jetpur', 'state_id' => 7, 'district_id' => 89],

            // Haryana (8) - Districts 96-117
            ['name' => 'Faridabad', 'state_id' => 8, 'district_id' => 99],
            ['name' => 'Gurgaon', 'state_id' => 8, 'district_id' => 101],
            ['name' => 'Panipat', 'state_id' => 8, 'district_id' => 112],
            ['name' => 'Ambala', 'state_id' => 8, 'district_id' => 96],
            ['name' => 'Yamunanagar', 'state_id' => 8, 'district_id' => 117],
            ['name' => 'Rohtak', 'state_id' => 8, 'district_id' => 114],
            ['name' => 'Hisar', 'state_id' => 8, 'district_id' => 102],
            ['name' => 'Karnal', 'state_id' => 8, 'district_id' => 106],
            ['name' => 'Sonipat', 'state_id' => 8, 'district_id' => 116],
            ['name' => 'Panchkula', 'state_id' => 8, 'district_id' => 111],
            ['name' => 'Bhiwani', 'state_id' => 8, 'district_id' => 97],
            ['name' => 'Sirsa', 'state_id' => 8, 'district_id' => 115],
            ['name' => 'Bahadurgarh', 'state_id' => 8, 'district_id' => 103],
            ['name' => 'Jind', 'state_id' => 8, 'district_id' => 104],
            ['name' => 'Thanesar', 'state_id' => 8, 'district_id' => 107],
            ['name' => 'Kaithal', 'state_id' => 8, 'district_id' => 105],
            ['name' => 'Rewari', 'state_id' => 8, 'district_id' => 113],
            ['name' => 'Narnaul', 'state_id' => 8, 'district_id' => 108],
            ['name' => 'Palwal', 'state_id' => 8, 'district_id' => 110],
            ['name' => 'Kosli', 'state_id' => 8, 'district_id' => 113],

            // Himachal Pradesh (9) - Districts 118-129
            ['name' => 'Bilaspur', 'state_id' => 9, 'district_id' => 118],
            ['name' => 'Chamba', 'state_id' => 9, 'district_id' => 119],
            ['name' => 'Hamirpur', 'state_id' => 9, 'district_id' => 120],
            ['name' => 'Dharamshala', 'state_id' => 9, 'district_id' => 121],
            ['name' => 'Palampur', 'state_id' => 9, 'district_id' => 121],
            ['name' => 'Kalpa', 'state_id' => 9, 'district_id' => 122],
            ['name' => 'Kullu', 'state_id' => 9, 'district_id' => 123],
            ['name' => 'Manali', 'state_id' => 9, 'district_id' => 123],
            ['name' => 'Keylong', 'state_id' => 9, 'district_id' => 124],
            ['name' => 'Mandi', 'state_id' => 9, 'district_id' => 125],
            ['name' => 'Sundarnagar', 'state_id' => 9, 'district_id' => 125],
            ['name' => 'Shimla', 'state_id' => 9, 'district_id' => 126],
            ['name' => 'Kasauli', 'state_id' => 9, 'district_id' => 126],
            ['name' => 'Nahan', 'state_id' => 9, 'district_id' => 127],
            ['name' => 'Paonta Sahib', 'state_id' => 9, 'district_id' => 127],
            ['name' => 'Solan', 'state_id' => 9, 'district_id' => 128],
            ['name' => 'Baddi', 'state_id' => 9, 'district_id' => 128],
            ['name' => 'Una', 'state_id' => 9, 'district_id' => 129],

            // Jharkhand (10) - Districts 130-153
            ['name' => 'Bokaro Steel City', 'state_id' => 10, 'district_id' => 130],
            ['name' => 'Chas', 'state_id' => 10, 'district_id' => 130],
            ['name' => 'Chatra', 'state_id' => 10, 'district_id' => 131],
            ['name' => 'Deoghar', 'state_id' => 10, 'district_id' => 132],
            ['name' => 'Dhanbad', 'state_id' => 10, 'district_id' => 133],
            ['name' => 'Jharia', 'state_id' => 10, 'district_id' => 133],
            ['name' => 'Dumka', 'state_id' => 10, 'district_id' => 134],
            ['name' => 'Jamshedpur', 'state_id' => 10, 'district_id' => 135],
            ['name' => 'Garhwa', 'state_id' => 10, 'district_id' => 136],
            ['name' => 'Giridih', 'state_id' => 10, 'district_id' => 137],
            ['name' => 'Godda', 'state_id' => 10, 'district_id' => 138],
            ['name' => 'Gumla', 'state_id' => 10, 'district_id' => 139],
            ['name' => 'Hazaribagh', 'state_id' => 10, 'district_id' => 140],
            ['name' => 'Jamtara', 'state_id' => 10, 'district_id' => 141],
            ['name' => 'Khunti', 'state_id' => 10, 'district_id' => 142],
            ['name' => 'Koderma', 'state_id' => 10, 'district_id' => 143],
            ['name' => 'Latehar', 'state_id' => 10, 'district_id' => 144],
            ['name' => 'Lohardaga', 'state_id' => 10, 'district_id' => 145],
            ['name' => 'Pakur', 'state_id' => 10, 'district_id' => 146],
            ['name' => 'Medininagar', 'state_id' => 10, 'district_id' => 147],
            ['name' => 'Ramgarh', 'state_id' => 10, 'district_id' => 148],
            ['name' => 'Ranchi', 'state_id' => 10, 'district_id' => 149],
            ['name' => 'Sahibganj', 'state_id' => 10, 'district_id' => 150],
            ['name' => 'Chaibasa', 'state_id' => 10, 'district_id' => 151],
            ['name' => 'Simdega', 'state_id' => 10, 'district_id' => 152],
            ['name' => 'Seraikela', 'state_id' => 10, 'district_id' => 153],

            // Karnataka (11) - Districts 154-183
            ['name' => 'Bagalkot', 'state_id' => 11, 'district_id' => 154],
            ['name' => 'Ballari', 'state_id' => 11, 'district_id' => 155],
            ['name' => 'Hospet', 'state_id' => 11, 'district_id' => 155],
            ['name' => 'Belagavi', 'state_id' => 11, 'district_id' => 156],
            ['name' => 'Belgaum', 'state_id' => 11, 'district_id' => 156],
            ['name' => 'Bangalore Rural', 'state_id' => 11, 'district_id' => 157],
            ['name' => 'Bangalore', 'state_id' => 11, 'district_id' => 158],
            ['name' => 'Bengaluru', 'state_id' => 11, 'district_id' => 158],
            ['name' => 'Bidar', 'state_id' => 11, 'district_id' => 159],
            ['name' => 'Chamarajanagar', 'state_id' => 11, 'district_id' => 160],
            ['name' => 'Chikkaballapur', 'state_id' => 11, 'district_id' => 161],
            ['name' => 'Chikkamagaluru', 'state_id' => 11, 'district_id' => 162],
            ['name' => 'Chitradurga', 'state_id' => 11, 'district_id' => 163],
            ['name' => 'Mangalore', 'state_id' => 11, 'district_id' => 164],
            ['name' => 'Udupi', 'state_id' => 11, 'district_id' => 164],
            ['name' => 'Davanagere', 'state_id' => 11, 'district_id' => 165],
            ['name' => 'Dharwad', 'state_id' => 11, 'district_id' => 166],
            ['name' => 'Hubli', 'state_id' => 11, 'district_id' => 166],
            ['name' => 'Gadag', 'state_id' => 11, 'district_id' => 167],
            ['name' => 'Hassan', 'state_id' => 11, 'district_id' => 168],
            ['name' => 'Haveri', 'state_id' => 11, 'district_id' => 169],
            ['name' => 'Gulbarga', 'state_id' => 11, 'district_id' => 170],
            ['name' => 'Kalaburagi', 'state_id' => 11, 'district_id' => 170],
            ['name' => 'Kodagu', 'state_id' => 11, 'district_id' => 171],
            ['name' => 'Kolar', 'state_id' => 11, 'district_id' => 172],
            ['name' => 'Koppal', 'state_id' => 11, 'district_id' => 173],
            ['name' => 'Mandya', 'state_id' => 11, 'district_id' => 174],
            ['name' => 'Mysore', 'state_id' => 11, 'district_id' => 175],
            ['name' => 'Mysuru', 'state_id' => 11, 'district_id' => 175],
            ['name' => 'Raichur', 'state_id' => 11, 'district_id' => 176],
            ['name' => 'Ramanagara', 'state_id' => 11, 'district_id' => 177],
            ['name' => 'Shimoga', 'state_id' => 11, 'district_id' => 178],
            ['name' => 'Shivamogga', 'state_id' => 11, 'district_id' => 178],
            ['name' => 'Tumkur', 'state_id' => 11, 'district_id' => 179],
            ['name' => 'Tumakuru', 'state_id' => 11, 'district_id' => 179],
            ['name' => 'Karwar', 'state_id' => 11, 'district_id' => 180],
            ['name' => 'Bijapur', 'state_id' => 11, 'district_id' => 181],
            ['name' => 'Vijayapura', 'state_id' => 11, 'district_id' => 181],
            ['name' => 'Yadgir', 'state_id' => 11, 'district_id' => 182],

            // Kerala (12) - Districts 183-196
            ['name' => 'Alappuzha', 'state_id' => 12, 'district_id' => 183],
            ['name' => 'Alleppey', 'state_id' => 12, 'district_id' => 183],
            ['name' => 'Kochi', 'state_id' => 12, 'district_id' => 184],
            ['name' => 'Ernakulam', 'state_id' => 12, 'district_id' => 184],
            ['name' => 'Munnar', 'state_id' => 12, 'district_id' => 185],
            ['name' => 'Idukki', 'state_id' => 12, 'district_id' => 185],
            ['name' => 'Kannur', 'state_id' => 12, 'district_id' => 186],
            ['name' => 'Kasaragod', 'state_id' => 12, 'district_id' => 187],
            ['name' => 'Kollam', 'state_id' => 12, 'district_id' => 188],
            ['name' => 'Quilon', 'state_id' => 12, 'district_id' => 188],
            ['name' => 'Kottayam', 'state_id' => 12, 'district_id' => 189],
            ['name' => 'Kozhikode', 'state_id' => 12, 'district_id' => 190],
            ['name' => 'Calicut', 'state_id' => 12, 'district_id' => 190],
            ['name' => 'Malappuram', 'state_id' => 12, 'district_id' => 191],
            ['name' => 'Palakkad', 'state_id' => 12, 'district_id' => 192],
            ['name' => 'Palghat', 'state_id' => 12, 'district_id' => 192],
            ['name' => 'Pathanamthitta', 'state_id' => 12, 'district_id' => 193],
            ['name' => 'Thiruvananthapuram', 'state_id' => 12, 'district_id' => 194],
            ['name' => 'Trivandrum', 'state_id' => 12, 'district_id' => 194],
            ['name' => 'Thrissur', 'state_id' => 12, 'district_id' => 195],
            ['name' => 'Trichur', 'state_id' => 12, 'district_id' => 195],
            ['name' => 'Wayanad', 'state_id' => 12, 'district_id' => 196],

            // Madhya Pradesh (13) - Districts 197-244
            ['name' => 'Bhopal', 'state_id' => 13, 'district_id' => 205],
            ['name' => 'Indore', 'state_id' => 13, 'district_id' => 218],
            ['name' => 'Jabalpur', 'state_id' => 13, 'district_id' => 219],
            ['name' => 'Gwalior', 'state_id' => 13, 'district_id' => 215],
            ['name' => 'Ujjain', 'state_id' => 13, 'district_id' => 244],
            ['name' => 'Sagar', 'state_id' => 13, 'district_id' => 233],
            ['name' => 'Dewas', 'state_id' => 13, 'district_id' => 211],
            ['name' => 'Satna', 'state_id' => 13, 'district_id' => 234],
            ['name' => 'Ratlam', 'state_id' => 13, 'district_id' => 231],
            ['name' => 'Rewa', 'state_id' => 13, 'district_id' => 232],
            ['name' => 'Murwara', 'state_id' => 13, 'district_id' => 220],
            ['name' => 'Singrauli', 'state_id' => 13, 'district_id' => 241],
            ['name' => 'Burhanpur', 'state_id' => 13, 'district_id' => 206],
            ['name' => 'Khandwa', 'state_id' => 13, 'district_id' => 222],
            ['name' => 'Bhind', 'state_id' => 13, 'district_id' => 204],
            ['name' => 'Chhindwara', 'state_id' => 13, 'district_id' => 208],
            ['name' => 'Guna', 'state_id' => 13, 'district_id' => 214],
            ['name' => 'Shivpuri', 'state_id' => 13, 'district_id' => 240],
            ['name' => 'Vidisha', 'state_id' => 13, 'district_id' => 245],
            ['name' => 'Chhatarpur', 'state_id' => 13, 'district_id' => 207],
            ['name' => 'Damoh', 'state_id' => 13, 'district_id' => 209],
            ['name' => 'Mandsaur', 'state_id' => 13, 'district_id' => 225],
            ['name' => 'Khargone', 'state_id' => 13, 'district_id' => 223],
            ['name' => 'Neemuch', 'state_id' => 13, 'district_id' => 228],
            ['name' => 'Pithampur', 'state_id' => 13, 'district_id' => 212],
            ['name' => 'Narmadapuram', 'state_id' => 13, 'district_id' => 216],
            ['name' => 'Itarsi', 'state_id' => 13, 'district_id' => 216],
            ['name' => 'Sehore', 'state_id' => 13, 'district_id' => 235],
            ['name' => 'Morena', 'state_id' => 13, 'district_id' => 226],
            ['name' => 'Betul', 'state_id' => 13, 'district_id' => 203],

            // Maharashtra (14) - Districts 245-280
            ['name' => 'Mumbai', 'state_id' => 14, 'district_id' => 261],
            ['name' => 'Pune', 'state_id' => 14, 'district_id' => 270],
            ['name' => 'Nagpur', 'state_id' => 14, 'district_id' => 263],
            ['name' => 'Thane', 'state_id' => 14, 'district_id' => 277],
            ['name' => 'Nashik', 'state_id' => 14, 'district_id' => 266],
            ['name' => 'Aurangabad', 'state_id' => 14, 'district_id' => 248],
            ['name' => 'Solapur', 'state_id' => 14, 'district_id' => 276],
            ['name' => 'Amravati', 'state_id' => 14, 'district_id' => 247],
            ['name' => 'Kolhapur', 'state_id' => 14, 'district_id' => 259],
            ['name' => 'Sangli', 'state_id' => 14, 'district_id' => 273],
            ['name' => 'Jalgaon', 'state_id' => 14, 'district_id' => 257],
            ['name' => 'Akola', 'state_id' => 14, 'district_id' => 246],
            ['name' => 'Latur', 'state_id' => 14, 'district_id' => 260],
            ['name' => 'Dhule', 'state_id' => 14, 'district_id' => 253],
            ['name' => 'Ahmednagar', 'state_id' => 14, 'district_id' => 245],
            ['name' => 'Chandrapur', 'state_id' => 14, 'district_id' => 252],
            ['name' => 'Parbhani', 'state_id' => 14, 'district_id' => 269],
            ['name' => 'Ichalkaranji', 'state_id' => 14, 'district_id' => 259],
            ['name' => 'Jalna', 'state_id' => 14, 'district_id' => 258],
            ['name' => 'Navi Mumbai', 'state_id' => 14, 'district_id' => 277],
            ['name' => 'Ambajogai', 'state_id' => 14, 'district_id' => 249],
            ['name' => 'Bhusawal', 'state_id' => 14, 'district_id' => 257],
            ['name' => 'Panvel', 'state_id' => 14, 'district_id' => 271],
            ['name' => 'Badlapur', 'state_id' => 14, 'district_id' => 277],
            ['name' => 'Beed', 'state_id' => 14, 'district_id' => 249],
            ['name' => 'Gondia', 'state_id' => 14, 'district_id' => 255],
            ['name' => 'Satara', 'state_id' => 14, 'district_id' => 274],
            ['name' => 'Barshi', 'state_id' => 14, 'district_id' => 276],
            ['name' => 'Yavatmal', 'state_id' => 14, 'district_id' => 280],
            ['name' => 'Achalpur', 'state_id' => 14, 'district_id' => 247],
            ['name' => 'Osmanabad', 'state_id' => 14, 'district_id' => 267],
            ['name' => 'Nandurbar', 'state_id' => 14, 'district_id' => 265],
            ['name' => 'Wardha', 'state_id' => 14, 'district_id' => 278],
            ['name' => 'Udgir', 'state_id' => 14, 'district_id' => 260],
            ['name' => 'Hinganghat', 'state_id' => 14, 'district_id' => 278],

            // Manipur (15) - Districts 281-296
            ['name' => 'Imphal', 'state_id' => 15, 'district_id' => 284],
            ['name' => 'Imphal East', 'state_id' => 15, 'district_id' => 284],
            ['name' => 'Imphal West', 'state_id' => 15, 'district_id' => 285],
            ['name' => 'Bishnupur', 'state_id' => 15, 'district_id' => 281],
            ['name' => 'Thoubal', 'state_id' => 15, 'district_id' => 295],
            ['name' => 'Lilong', 'state_id' => 15, 'district_id' => 295],
            ['name' => 'Mayang Imphal', 'state_id' => 15, 'district_id' => 284],
            ['name' => 'Kakching', 'state_id' => 15, 'district_id' => 287],
            ['name' => 'Churachandpur', 'state_id' => 15, 'district_id' => 283],
            ['name' => 'Senapati', 'state_id' => 15, 'district_id' => 292],
            ['name' => 'Ukhrul', 'state_id' => 15, 'district_id' => 296],
            ['name' => 'Tamenglong', 'state_id' => 15, 'district_id' => 293],

            // Meghalaya (16) - Districts 297-307
            ['name' => 'Shillong', 'state_id' => 16, 'district_id' => 299],
            ['name' => 'Tura', 'state_id' => 16, 'district_id' => 305],
            ['name' => 'Nongstoin', 'state_id' => 16, 'district_id' => 304],
            ['name' => 'Jowai', 'state_id' => 16, 'district_id' => 298],
            ['name' => 'Baghmara', 'state_id' => 16, 'district_id' => 302],
            ['name' => 'Williamnagar', 'state_id' => 16, 'district_id' => 300],
            ['name' => 'Nongpoh', 'state_id' => 16, 'district_id' => 301],
            ['name' => 'Mairang', 'state_id' => 16, 'district_id' => 304],
            ['name' => 'Resubelpara', 'state_id' => 16, 'district_id' => 300],
            ['name' => 'Ampati', 'state_id' => 16, 'district_id' => 303],

            // Mizoram (17) - Districts 308-318
            ['name' => 'Aizawl', 'state_id' => 17, 'district_id' => 308],
            ['name' => 'Lunglei', 'state_id' => 17, 'district_id' => 314],
            ['name' => 'Saiha', 'state_id' => 17, 'district_id' => 316],
            ['name' => 'Champhai', 'state_id' => 17, 'district_id' => 309],
            ['name' => 'Kolasib', 'state_id' => 17, 'district_id' => 312],
            ['name' => 'Serchhip', 'state_id' => 17, 'district_id' => 318],
            ['name' => 'Mamit', 'state_id' => 17, 'district_id' => 315],
            ['name' => 'Lawngtlai', 'state_id' => 17, 'district_id' => 313],
            ['name' => 'Saitual', 'state_id' => 17, 'district_id' => 317],
            ['name' => 'Khawzawl', 'state_id' => 17, 'district_id' => 311],

            // Nagaland (18) - Districts 319-331
            ['name' => 'Kohima', 'state_id' => 18, 'district_id' => 322],
            ['name' => 'Dimapur', 'state_id' => 18, 'district_id' => 320],
            ['name' => 'Mokokchung', 'state_id' => 18, 'district_id' => 324],
            ['name' => 'Tuensang', 'state_id' => 18, 'district_id' => 329],
            ['name' => 'Wokha', 'state_id' => 18, 'district_id' => 330],
            ['name' => 'Zunheboto', 'state_id' => 18, 'district_id' => 331],
            ['name' => 'Phek', 'state_id' => 18, 'district_id' => 328],
            ['name' => 'Kiphire', 'state_id' => 18, 'district_id' => 321],
            ['name' => 'Longleng', 'state_id' => 18, 'district_id' => 323],
            ['name' => 'Peren', 'state_id' => 18, 'district_id' => 327],
            ['name' => 'Mon', 'state_id' => 18, 'district_id' => 325],

            // Odisha (19) - Districts 332-361
            ['name' => 'Bhubaneswar', 'state_id' => 19, 'district_id' => 350],
            ['name' => 'Cuttack', 'state_id' => 19, 'district_id' => 338],
            ['name' => 'Rourkela', 'state_id' => 19, 'district_id' => 361],
            ['name' => 'Berhampur', 'state_id' => 19, 'district_id' => 342],
            ['name' => 'Sambalpur', 'state_id' => 19, 'district_id' => 359],
            ['name' => 'Puri', 'state_id' => 19, 'district_id' => 357],
            ['name' => 'Balasore', 'state_id' => 19, 'district_id' => 334],
            ['name' => 'Bhadrak', 'state_id' => 19, 'district_id' => 336],
            ['name' => 'Baripada', 'state_id' => 19, 'district_id' => 353],
            ['name' => 'Jharsuguda', 'state_id' => 19, 'district_id' => 345],
            ['name' => 'Jeypore', 'state_id' => 19, 'district_id' => 351],
            ['name' => 'Barbil', 'state_id' => 19, 'district_id' => 348],
            ['name' => 'Khordha', 'state_id' => 19, 'district_id' => 350],
            ['name' => 'Sunabeda', 'state_id' => 19, 'district_id' => 351],
            ['name' => 'Rayagada', 'state_id' => 19, 'district_id' => 358],
            ['name' => 'Kendujhar', 'state_id' => 19, 'district_id' => 349],
            ['name' => 'Jagatsinghpur', 'state_id' => 19, 'district_id' => 343],
            ['name' => 'Paradeep', 'state_id' => 19, 'district_id' => 343],
            ['name' => 'Bhawanipatna', 'state_id' => 19, 'district_id' => 346],
            ['name' => 'Dhenkanal', 'state_id' => 19, 'district_id' => 340],

            // Punjab (20) - Districts 362-382
            ['name' => 'Ludhiana', 'state_id' => 20, 'district_id' => 373],
            ['name' => 'Amritsar', 'state_id' => 20, 'district_id' => 362],
            ['name' => 'Jalandhar', 'state_id' => 20, 'district_id' => 371],
            ['name' => 'Patiala', 'state_id' => 20, 'district_id' => 377],
            ['name' => 'Bathinda', 'state_id' => 20, 'district_id' => 364],
            ['name' => 'Mohali', 'state_id' => 20, 'district_id' => 380],
            ['name' => 'Firozpur', 'state_id' => 20, 'district_id' => 368],
            ['name' => 'Batala', 'state_id' => 20, 'district_id' => 369],
            ['name' => 'Pathankot', 'state_id' => 20, 'district_id' => 376],
            ['name' => 'Moga', 'state_id' => 20, 'district_id' => 375],
            ['name' => 'Abohar', 'state_id' => 20, 'district_id' => 367],
            ['name' => 'Malerkotla', 'state_id' => 20, 'district_id' => 374],
            ['name' => 'Khanna', 'state_id' => 20, 'district_id' => 373],
            ['name' => 'Phagwara', 'state_id' => 20, 'district_id' => 372],
            ['name' => 'Muktsar', 'state_id' => 20, 'district_id' => 381],
            ['name' => 'Barnala', 'state_id' => 20, 'district_id' => 363],
            ['name' => 'Rajpura', 'state_id' => 20, 'district_id' => 377],
            ['name' => 'Hoshiarpur', 'state_id' => 20, 'district_id' => 370],
            ['name' => 'Kapurthala', 'state_id' => 20, 'district_id' => 372],
            ['name' => 'Faridkot', 'state_id' => 20, 'district_id' => 365],

            // Rajasthan (21) - Districts 383-415
            ['name' => 'Jaipur', 'state_id' => 21, 'district_id' => 398],
            ['name' => 'Jodhpur', 'state_id' => 21, 'district_id' => 403],
            ['name' => 'Kota', 'state_id' => 21, 'district_id' => 405],
            ['name' => 'Bikaner', 'state_id' => 21, 'district_id' => 390],
            ['name' => 'Ajmer', 'state_id' => 21, 'district_id' => 383],
            ['name' => 'Udaipur', 'state_id' => 21, 'district_id' => 415],
            ['name' => 'Bhilwara', 'state_id' => 21, 'district_id' => 389],
            ['name' => 'Alwar', 'state_id' => 21, 'district_id' => 384],
            ['name' => 'Bharatpur', 'state_id' => 21, 'district_id' => 388],
            ['name' => 'Pali', 'state_id' => 21, 'district_id' => 407],
            ['name' => 'Barmer', 'state_id' => 21, 'district_id' => 387],
            ['name' => 'Sikar', 'state_id' => 21, 'district_id' => 411],
            ['name' => 'Tonk', 'state_id' => 21, 'district_id' => 414],
            ['name' => 'Kishangarh', 'state_id' => 21, 'district_id' => 383],
            ['name' => 'Beawar', 'state_id' => 21, 'district_id' => 383],
            ['name' => 'Hanumangarh', 'state_id' => 21, 'district_id' => 397],
            ['name' => 'Gangapur City', 'state_id' => 21, 'district_id' => 410],
            ['name' => 'Churu', 'state_id' => 21, 'district_id' => 393],
            ['name' => 'Jhunjhunu', 'state_id' => 21, 'district_id' => 402],
            ['name' => 'Sri Ganganagar', 'state_id' => 21, 'district_id' => 413],
            ['name' => 'Sawai Madhopur', 'state_id' => 21, 'district_id' => 410],
            ['name' => 'Makrana', 'state_id' => 21, 'district_id' => 407],
            ['name' => 'Sujangarh', 'state_id' => 21, 'district_id' => 406],
            ['name' => 'Lachhmangarh', 'state_id' => 21, 'district_id' => 411],
            ['name' => 'Rajsamand', 'state_id' => 21, 'district_id' => 409],
            ['name' => 'Nokha', 'state_id' => 21, 'district_id' => 390],
            ['name' => 'Chittorgarh', 'state_id' => 21, 'district_id' => 392],
            ['name' => 'Nagaur', 'state_id' => 21, 'district_id' => 406],
            ['name' => 'Banswara', 'state_id' => 21, 'district_id' => 385],
            ['name' => 'Bundi', 'state_id' => 21, 'district_id' => 391],

            // Sikkim (22) - Districts 416-419
            ['name' => 'Gangtok', 'state_id' => 22, 'district_id' => 416],
            ['name' => 'Namchi', 'state_id' => 22, 'district_id' => 418],
            ['name' => 'Geyzing', 'state_id' => 22, 'district_id' => 419],
            ['name' => 'Mangan', 'state_id' => 22, 'district_id' => 417],
            ['name' => 'Jorethang', 'state_id' => 22, 'district_id' => 418],
            ['name' => 'Naya Bazar', 'state_id' => 22, 'district_id' => 416],
            ['name' => 'Rangpo', 'state_id' => 22, 'district_id' => 416],
            ['name' => 'Singtam', 'state_id' => 22, 'district_id' => 416],
            ['name' => 'Yuksom', 'state_id' => 22, 'district_id' => 419],
            ['name' => 'Pelling', 'state_id' => 22, 'district_id' => 419],

            // Tamil Nadu (23) - Districts 420-457
            ['name' => 'Chennai', 'state_id' => 23, 'district_id' => 422],
            ['name' => 'Coimbatore', 'state_id' => 23, 'district_id' => 423],
            ['name' => 'Madurai', 'state_id' => 23, 'district_id' => 433],
            ['name' => 'Tiruchirappalli', 'state_id' => 23, 'district_id' => 449],
            ['name' => 'Salem', 'state_id' => 23, 'district_id' => 442],
            ['name' => 'Tiruppur', 'state_id' => 23, 'district_id' => 451],
            ['name' => 'Erode', 'state_id' => 23, 'district_id' => 427],
            ['name' => 'Tirunelveli', 'state_id' => 23, 'district_id' => 450],
            ['name' => 'Vellore', 'state_id' => 23, 'district_id' => 456],
            ['name' => 'Thoothukudi', 'state_id' => 23, 'district_id' => 448],
            ['name' => 'Dindigul', 'state_id' => 23, 'district_id' => 426],
            ['name' => 'Thanjavur', 'state_id' => 23, 'district_id' => 446],
            ['name' => 'Ranipet', 'state_id' => 23, 'district_id' => 441],
            ['name' => 'Sivakasi', 'state_id' => 23, 'district_id' => 457],
            ['name' => 'Karur', 'state_id' => 23, 'district_id' => 431],
            ['name' => 'Udhagamandalam', 'state_id' => 23, 'district_id' => 437],
            ['name' => 'Hosur', 'state_id' => 23, 'district_id' => 432],
            ['name' => 'Nagercoil', 'state_id' => 23, 'district_id' => 430],
            ['name' => 'Kanchipuram', 'state_id' => 23, 'district_id' => 429],
            ['name' => 'Kumarakoil', 'state_id' => 23, 'district_id' => 430],
            ['name' => 'Kumbakonam', 'state_id' => 23, 'district_id' => 446],
            ['name' => 'Karaikudi', 'state_id' => 23, 'district_id' => 443],
            ['name' => 'Neyveli', 'state_id' => 23, 'district_id' => 424],
            ['name' => 'Palani', 'state_id' => 23, 'district_id' => 426],
            ['name' => 'Pollachi', 'state_id' => 23, 'district_id' => 423],
            ['name' => 'Ramanathapuram', 'state_id' => 23, 'district_id' => 440],
            ['name' => 'Tenkasi', 'state_id' => 23, 'district_id' => 444],
            ['name' => 'Theni', 'state_id' => 23, 'district_id' => 447],
            ['name' => 'Tiruchendur', 'state_id' => 23, 'district_id' => 448],
            ['name' => 'Tiruvannamalai', 'state_id' => 23, 'district_id' => 454],
            ['name' => 'Villupuram', 'state_id' => 23, 'district_id' => 456],
            ['name' => 'Virudhunagar', 'state_id' => 23, 'district_id' => 457],

            // Telangana (24) - Districts 458-490
            ['name' => 'Hyderabad', 'state_id' => 24, 'district_id' => 461],
            ['name' => 'Warangal', 'state_id' => 24, 'district_id' => 490],
            ['name' => 'Nizamabad', 'state_id' => 24, 'district_id' => 481],
            ['name' => 'Khammam', 'state_id' => 24, 'district_id' => 469],
            ['name' => 'Karimnagar', 'state_id' => 24, 'district_id' => 468],
            ['name' => 'Ramagundam', 'state_id' => 24, 'district_id' => 482],
            ['name' => 'Mahabubnagar', 'state_id' => 24, 'district_id' => 472],
            ['name' => 'Nalgonda', 'state_id' => 24, 'district_id' => 478],
            ['name' => 'Adilabad', 'state_id' => 24, 'district_id' => 458],
            ['name' => 'Suryapet', 'state_id' => 24, 'district_id' => 487],
            ['name' => 'Miryalaguda', 'state_id' => 24, 'district_id' => 478],
            ['name' => 'Jagtial', 'state_id' => 24, 'district_id' => 463],
            ['name' => 'Mancherial', 'state_id' => 24, 'district_id' => 473],
            ['name' => 'Nirmal', 'state_id' => 24, 'district_id' => 480],
            ['name' => 'Kothagudem', 'state_id' => 24, 'district_id' => 459],
            ['name' => 'Bodhan', 'state_id' => 24, 'district_id' => 481],
            ['name' => 'Sangareddy', 'state_id' => 24, 'district_id' => 485],
            ['name' => 'Metpally', 'state_id' => 24, 'district_id' => 463],
            ['name' => 'Zahirabad', 'state_id' => 24, 'district_id' => 485],
            ['name' => 'Medak', 'state_id' => 24, 'district_id' => 474],
            ['name' => 'Siddipet', 'state_id' => 24, 'district_id' => 486],

            // Tripura (25) - Districts 491-498
            ['name' => 'Agartala', 'state_id' => 25, 'district_id' => 498],
            ['name' => 'Dharmanagar', 'state_id' => 25, 'district_id' => 494],
            ['name' => 'Udaipur', 'state_id' => 25, 'district_id' => 496],
            ['name' => 'Kailasahar', 'state_id' => 25, 'district_id' => 494],
            ['name' => 'Belonia', 'state_id' => 25, 'district_id' => 496],
            ['name' => 'Khowai', 'state_id' => 25, 'district_id' => 493],
            ['name' => 'Pratapgarh', 'state_id' => 25, 'district_id' => 492],
            ['name' => 'Ranir Bazar', 'state_id' => 25, 'district_id' => 497],
            ['name' => 'Sonamura', 'state_id' => 25, 'district_id' => 497],
            ['name' => 'Kumarghat', 'state_id' => 25, 'district_id' => 497],

            // Uttar Pradesh (26) - Districts 499-573
            ['name' => 'Lucknow', 'state_id' => 26, 'district_id' => 547],
            ['name' => 'Kanpur', 'state_id' => 26, 'district_id' => 540],
            ['name' => 'Ghaziabad', 'state_id' => 26, 'district_id' => 527],
            ['name' => 'Agra', 'state_id' => 26, 'district_id' => 499],
            ['name' => 'Varanasi', 'state_id' => 26, 'district_id' => 573],
            ['name' => 'Meerut', 'state_id' => 26, 'district_id' => 555],
            ['name' => 'Allahabad', 'state_id' => 26, 'district_id' => 563],
            ['name' => 'Bareilly', 'state_id' => 26, 'district_id' => 507],
            ['name' => 'Aligarh', 'state_id' => 26, 'district_id' => 500],
            ['name' => 'Moradabad', 'state_id' => 26, 'district_id' => 556],
            ['name' => 'Saharanpur', 'state_id' => 26, 'district_id' => 565],
            ['name' => 'Gorakhpur', 'state_id' => 26, 'district_id' => 529],
            ['name' => 'Noida', 'state_id' => 26, 'district_id' => 526],
            ['name' => 'Firozabad', 'state_id' => 26, 'district_id' => 525],
            ['name' => 'Loni', 'state_id' => 26, 'district_id' => 527],
            ['name' => 'Jhansi', 'state_id' => 26, 'district_id' => 537],
            ['name' => 'Muzaffarnagar', 'state_id' => 26, 'district_id' => 557],
            ['name' => 'Mathura', 'state_id' => 26, 'district_id' => 553],
            ['name' => 'Shahjahanpur', 'state_id' => 26, 'district_id' => 567],
            ['name' => 'Rampur', 'state_id' => 26, 'district_id' => 564],
            ['name' => 'Mau', 'state_id' => 26, 'district_id' => 554],
            ['name' => 'Farrukhabad', 'state_id' => 26, 'district_id' => 524],
            ['name' => 'Hapur', 'state_id' => 26, 'district_id' => 532],
            ['name' => 'Etawah', 'state_id' => 26, 'district_id' => 523],
            ['name' => 'Mirzapur', 'state_id' => 26, 'district_id' => 555],
            ['name' => 'Bulandshahr', 'state_id' => 26, 'district_id' => 512],
            ['name' => 'Sambhal', 'state_id' => 26, 'district_id' => 566],
            ['name' => 'Amroha', 'state_id' => 26, 'district_id' => 503],
            ['name' => 'Hardoi', 'state_id' => 26, 'district_id' => 533],
            ['name' => 'Fatehpur', 'state_id' => 26, 'district_id' => 525],
            ['name' => 'Raebareli', 'state_id' => 26, 'district_id' => 562],
            ['name' => 'Orai', 'state_id' => 26, 'district_id' => 535],
            ['name' => 'Sitapur', 'state_id' => 26, 'district_id' => 570],
            ['name' => 'Bahraich', 'state_id' => 26, 'district_id' => 504],
            ['name' => 'Modinagar', 'state_id' => 26, 'district_id' => 527],
            ['name' => 'Unnao', 'state_id' => 26, 'district_id' => 572],
            ['name' => 'Jaunpur', 'state_id' => 26, 'district_id' => 536],
            ['name' => 'Lakhimpur', 'state_id' => 26, 'district_id' => 546],
            ['name' => 'Hathras', 'state_id' => 26, 'district_id' => 534],
            ['name' => 'Banda', 'state_id' => 26, 'district_id' => 505],

            // Uttarakhand (27) - Districts 574-586
            ['name' => 'Dehradun', 'state_id' => 27, 'district_id' => 578],
            ['name' => 'Haridwar', 'state_id' => 27, 'district_id' => 579],
            ['name' => 'Roorkee', 'state_id' => 27, 'district_id' => 579],
            ['name' => 'Haldwani-cum-Kathgodam', 'state_id' => 27, 'district_id' => 580],
            ['name' => 'Rudrapur', 'state_id' => 27, 'district_id' => 585],
            ['name' => 'Kashipur', 'state_id' => 27, 'district_id' => 585],
            ['name' => 'Rishikesh', 'state_id' => 27, 'district_id' => 578],
            ['name' => 'Ramnagar', 'state_id' => 27, 'district_id' => 580],
            ['name' => 'Pithoragarh', 'state_id' => 27, 'district_id' => 582],
            ['name' => 'Jaspur', 'state_id' => 27, 'district_id' => 585],
            ['name' => 'Askot', 'state_id' => 27, 'district_id' => 582],
            ['name' => 'Kaladhungi', 'state_id' => 27, 'district_id' => 580],
            ['name' => 'Mussoorie', 'state_id' => 27, 'district_id' => 578],
            ['name' => 'Tehri', 'state_id' => 27, 'district_id' => 584],
            ['name' => 'Pauri', 'state_id' => 27, 'district_id' => 581],
            ['name' => 'Srinagar', 'state_id' => 27, 'district_id' => 581],
            ['name' => 'Kotdwara', 'state_id' => 27, 'district_id' => 581],
            ['name' => 'Nainital', 'state_id' => 27, 'district_id' => 580],
            ['name' => 'Almora', 'state_id' => 27, 'district_id' => 574],
            ['name' => 'Champawat', 'state_id' => 27, 'district_id' => 577],

            // West Bengal (28) - Districts 587-609
            ['name' => 'Kolkata', 'state_id' => 28, 'district_id' => 598],
            ['name' => 'Howrah', 'state_id' => 28, 'district_id' => 594],
            ['name' => 'Durgapur', 'state_id' => 28, 'district_id' => 603],
            ['name' => 'Asansol', 'state_id' => 28, 'district_id' => 603],
            ['name' => 'Siliguri', 'state_id' => 28, 'district_id' => 592],
            ['name' => 'Bardhaman', 'state_id' => 28, 'district_id' => 605],
            ['name' => 'Malda', 'state_id' => 28, 'district_id' => 599],
            ['name' => 'Baharampur', 'state_id' => 28, 'district_id' => 600],
            ['name' => 'Habra', 'state_id' => 28, 'district_id' => 602],
            ['name' => 'Kharagpur', 'state_id' => 28, 'district_id' => 604],
            ['name' => 'Shantipur', 'state_id' => 28, 'district_id' => 601],
            ['name' => 'Dankuni', 'state_id' => 28, 'district_id' => 594],
            ['name' => 'Dhulian', 'state_id' => 28, 'district_id' => 600],
            ['name' => 'Ranaghat', 'state_id' => 28, 'district_id' => 601],
            ['name' => 'Haldia', 'state_id' => 28, 'district_id' => 606],
            ['name' => 'Raiganj', 'state_id' => 28, 'district_id' => 609],
            ['name' => 'Krishnanagar', 'state_id' => 28, 'district_id' => 601],
            ['name' => 'Nabadwip', 'state_id' => 28, 'district_id' => 601],
            ['name' => 'Medinipur', 'state_id' => 28, 'district_id' => 604],
            ['name' => 'Jalpaiguri', 'state_id' => 28, 'district_id' => 595],
            ['name' => 'Balurghat', 'state_id' => 28, 'district_id' => 591],
            ['name' => 'Basirhat', 'state_id' => 28, 'district_id' => 602],
            ['name' => 'Bankura', 'state_id' => 28, 'district_id' => 588],
            ['name' => 'Chakdaha', 'state_id' => 28, 'district_id' => 601],
            ['name' => 'Darjeeling', 'state_id' => 28, 'district_id' => 592],
            ['name' => 'Alipurduar', 'state_id' => 28, 'district_id' => 587],
            ['name' => 'Purulia', 'state_id' => 28, 'district_id' => 607],
            ['name' => 'Jangipur', 'state_id' => 28, 'district_id' => 600],
            ['name' => 'Bolpur', 'state_id' => 28, 'district_id' => 589],
            ['name' => 'Bangaon', 'state_id' => 28, 'district_id' => 602],

            // Union Territories
            // Andaman and Nicobar Islands (29) - Districts 610-612
            ['name' => 'Port Blair', 'state_id' => 29, 'district_id' => 612],

            // Chandigarh (30) - District 613
            ['name' => 'Chandigarh', 'state_id' => 30, 'district_id' => 613],

            // Dadra and Nagar Haveli and Daman and Diu (31) - Districts 614-615
            ['name' => 'Daman', 'state_id' => 31, 'district_id' => 615],
            ['name' => 'Diu', 'state_id' => 31, 'district_id' => 615],
            ['name' => 'Silvassa', 'state_id' => 31, 'district_id' => 614],
            ['name' => 'Dadra', 'state_id' => 31, 'district_id' => 614],

            // Delhi (32) - Districts 616-626
            ['name' => 'Delhi', 'state_id' => 32, 'district_id' => 618],
            ['name' => 'New Delhi', 'state_id' => 32, 'district_id' => 618],

            // Jammu and Kashmir (33) - Districts 627-628
            ['name' => 'Srinagar', 'state_id' => 33, 'district_id' => 627],
            ['name' => 'Jammu', 'state_id' => 33, 'district_id' => 627],

            // Ladakh (34) - Districts 629-630
            ['name' => 'Leh', 'state_id' => 34, 'district_id' => 630],
            ['name' => 'Kargil', 'state_id' => 34, 'district_id' => 629],

            // Lakshadweep (35) - District 631
            ['name' => 'Kavaratti', 'state_id' => 35, 'district_id' => 631],

            // Puducherry (36) - Districts 632-635
            ['name' => 'Puducherry', 'state_id' => 36, 'district_id' => 634]
        ];

        foreach ($cities as $cityData) {
            City::create(array_merge($cityData, [
                'status' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ]));
        }
    }
}