<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('applicant_lead_status_logs', function (Blueprint $table) {
            $table->dropForeign(['lead_id']);
            $table->renameColumn('lead_id', 'applicant_lead_id');
            $table->foreign('applicant_lead_id')->references('id')->on('applicants')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('applicant_lead_status_logs', function (Blueprint $table) {
            $table->dropForeign(['applicant_lead_id']);
            $table->renameColumn('applicant_lead_id', 'lead_id');
            $table->foreign('lead_id')->references('id')->on('applicants')->onDelete('cascade');
        });
    }
};
