<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('applicant_lead_status_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('lead_id');
            $table->integer('lead_status');
            $table->unsignedBigInteger('action_by');
            $table->datetime('action_date');
            $table->softDeletes();
            $table->timestamps();
            
            $table->foreign('lead_id')->references('id')->on('applicants')->onDelete('cascade');
            $table->foreign('action_by')->references('id')->on('users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('applicant_lead_status_logs');
    }
};
