<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('applicant_guarantors', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('applicant_id');
            
            // Personal Information
            $table->string('guarantor_first_name');
            $table->string('applicant_middle_name')->nullable();
            $table->string('applicant_last_name');
            $table->string('father_name');
            $table->integer('caste_id')->nullable();
            $table->date('dob')->nullable();
            $table->integer('age')->nullable();
            $table->integer('gender_id')->nullable();
            $table->string('contact_number');
            
            // Address Information
            $table->integer('address_type_id')->nullable();
            $table->text('current_address');
            $table->string('current_city')->nullable();
            $table->string('current_state')->nullable();
            $table->string('current_pincode');
            $table->string('place_of_birth');
            $table->string('nationality')->default('Indian');
            $table->integer('marital_status_id')->nullable();
            $table->string('spouse_name')->nullable();
            $table->string('email')->nullable();
            
            // Identity Documents
            $table->string('pan')->nullable();
            $table->string('aadhaar')->nullable();
            $table->string('voter_id')->nullable();
            $table->string('driving_license')->nullable();
            $table->string('passport')->nullable();
            $table->boolean('form_60')->default(false);
            
            // System Fields
            $table->integer('status')->default(1);
            $table->timestamps();
            $table->softDeletes();
            
            // Foreign key constraint
            $table->foreign('applicant_id')->references('id')->on('applicants')->onDelete('cascade');
            
            // Indexes
            $table->index('applicant_id');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('applicant_guarantors');
    }
};