<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('form_field_options', function (Blueprint $table) {
            $table->integer('priority')->default(0)->after('option_value');
            $table->dropColumn('option_label');
        });
    }

    public function down(): void
    {
        Schema::table('form_field_options', function (Blueprint $table) {
            $table->dropColumn('priority');
            $table->string('option_label', 150)->after('field_id');
        });
    }
};