<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('father_name')->nullable()->after('name');
            $table->string('mother_name')->nullable()->after('father_name');
            $table->date('dob')->nullable()->after('mother_name');
            $table->enum('gender', ['male', 'female', 'other'])->nullable()->after('dob');
            $table->enum('marital_status', ['single', 'married', 'divorced', 'widowed'])->nullable()->after('gender');
            $table->string('alternate_mobile')->nullable()->after('mobile');
            $table->string('aadhaar_number', 12)->nullable()->after('alternate_mobile');
            $table->string('pan_number', 10)->nullable()->after('aadhaar_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'father_name',
                'mother_name', 
                'dob',
                'gender',
                'marital_status',
                'alternate_mobile',
                'aadhaar_number',
                'pan_number'
            ]);
        });
    }
};
