<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        $tables = ['users', 'states', 'cities'];
        
        foreach ($tables as $table) {
            if (Schema::hasTable($table)) {
                DB::statement("ALTER TABLE `{$table}` MODIFY `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
                DB::statement("ALTER TABLE `{$table}` MODIFY `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
            }
        }
    }

    public function down(): void
    {
        $tables = ['users', 'states', 'cities'];
        
        foreach ($tables as $table) {
            if (Schema::hasTable($table)) {
                DB::statement("ALTER TABLE `{$table}` MODIFY `created_at` TIMESTAMP NULL DEFAULT NULL");
                DB::statement("ALTER TABLE `{$table}` MODIFY `updated_at` TIMESTAMP NULL DEFAULT NULL");
            }
        }
    }
};