<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $now = now();
        
        // Update existing records with current timestamp
        $tables = ['users', 'states', 'cities', 'roles', 'designations', 'circles'];
        
        foreach ($tables as $table) {
            if (Schema::hasTable($table)) {
                DB::table($table)
                    ->whereNull('created_at')
                    ->orWhereNull('updated_at')
                    ->update([
                        'created_at' => $now,
                        'updated_at' => $now
                    ]);
            }
        }
    }

    public function down(): void
    {
        // Cannot reverse timestamp updates
    }
};