<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Add timestamps to tables that don't have them
        $tables = ['states', 'cities', 'roles', 'designations', 'circles'];
        
        foreach ($tables as $table) {
            if (Schema::hasTable($table)) {
                Schema::table($table, function (Blueprint $table) {
                    if (!Schema::hasColumn($table->getTable(), 'created_at')) {
                        $table->timestamps();
                    }
                });
            }
        }
    }

    public function down(): void
    {
        $tables = ['states', 'cities', 'roles', 'designations', 'circles'];
        
        foreach ($tables as $table) {
            if (Schema::hasTable($table)) {
                Schema::table($table, function (Blueprint $table) {
                    $table->dropTimestamps();
                });
            }
        }
    }
};