<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->id();
            $table->string('staff_id')->nullable();
            $table->time('in_time')->nullable();
            $table->time('out_time')->nullable();
            $table->date('date')->nullable();
            $table->string('working_hours')->nullable();
            $table->string('in_time_status')->nullable();
            $table->string('out_time_status')->nullable();
            $table->decimal('in_time_lat', 10, 8)->nullable();
            $table->decimal('in_time_long', 11, 8)->nullable();
            $table->text('in_time_address')->nullable();
            $table->decimal('out_time_lat', 10, 8)->nullable();
            $table->decimal('out_time_long', 11, 8)->nullable();
            $table->text('out_time_address')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('attendances');
    }
};