<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('support_number1')->nullable();
            $table->string('support_number2')->nullable();
            $table->boolean('maintenance_mode')->default(false);
            $table->string('version')->nullable();
            $table->string('status1')->nullable();
            $table->string('status2')->nullable();
            $table->string('status3')->nullable();
            $table->string('status4')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};