<?php

namespace App\Utils;

use Illuminate\Support\Facades\Storage;

class FileUpload
{
    public static function uploadImage($file, $folder, $prefix = null)
    {
        try {
            if (!$file || !$file->isValid()) {
                return null;
            }
            
            $filename = ($prefix ?? 'file') . '_' . time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
            $relativePath = "uploads/{$folder}/{$filename}";
            Storage::disk('public')->putFileAs("uploads/{$folder}", $file, $filename);
            
            return $filename;
        } catch (\Exception $e) {
            return null;
        }
    }
}