<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Regularize extends Model
{
    use HasFactory;

    protected $fillable = [
        'staff_id',
        'date',
        'remark',
        'status',
    ];

    protected $casts = [
        'date' => 'date',
        'status' => 'integer',
    ];

    /**
     * Get the user who owns this regularize record
     * Relationship: Each Regularize belongs to One User (based on staff_id)
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'staff_id', 'staff_id');
    }
}