<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Permission extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'role_id',
        'menu_id',
        'sub_menu',
        'sub_child_menu',
    ];

    /**
     * Convert comma-separated menu_id string to array
     */
    public function getMenuIdArrayAttribute()
    {
        return $this->menu_id ? explode(',', $this->menu_id) : [];
    }

    /**
     * Convert comma-separated sub_menu string to array
     */
    public function getSubMenuArrayAttribute()
    {
        return $this->sub_menu ? explode(',', $this->sub_menu) : [];
    }

    /**
     * Convert comma-separated sub_child_menu string to array
     */
    public function getSubChildMenuArrayAttribute()
    {
        return $this->sub_child_menu ? explode(',', $this->sub_child_menu) : [];
    }

    /**
     * Get the menu that owns this permission
     */
    public function menu()
    {
        return $this->belongsTo(Menu::class, 'menu_id');
    }

    /**
     * Get submenus for this permission
     */
    public function subMenus()
    {
        if (!$this->sub_menu) {
            return collect();
        }
        
        $submenuIds = explode(',', $this->sub_menu);
        return SubMenu::whereIn('id', $submenuIds)->get();
    }
}