<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IdentityDocument extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'document_id',
        'applicant_id',
        'document_type',
        'document_number',
        'verified',
        'verification_method',
        'verification_date'
    ];

    protected $casts = [
        'verification_date' => 'datetime',
        'verified' => 'boolean'
    ];

    public function applicant()
    {
        return $this->belongsTo(Applicant::class);
    }
}