<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormFieldOption extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'field_id',
        'option_value',
        'parent_id',
        'priority',
        'status'
    ];

    protected $casts = [
        'status' => 'boolean'
    ];

    public function formField()
    {
        return $this->belongsTo(FormField::class, 'field_id');
    }

    public function parent()
    {
        return $this->belongsTo(FormFieldOption::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(FormFieldOption::class, 'parent_id');
    }
}