<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormField extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'field_name',
        'field_label',
        'field_type',
        'master_type',
        'parent_field_id',
        'status'
    ];

    protected $casts = [
        'status' => 'boolean'
    ];

    public function options()
    {
        return $this->hasMany(FormFieldOption::class, 'field_id');
    }

    public function parentField()
    {
        return $this->belongsTo(FormField::class, 'parent_field_id');
    }

    public function subFields()
    {
        return $this->hasMany(FormField::class, 'parent_field_id');
    }

    protected static function boot()
    {
        parent::boot();
        
        static::deleting(function ($formField) {
            $formField->options()->delete();
        });
    }
}