<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CoApplicant extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'applicant_id',
        'co_applicant_first_name',
        'applicant_middle_name',
        'applicant_last_name',
        'father_name',
        'caste_id',
        'dob',
        'age',
        'gender_id',
        'contact_number',
        'address_type_id',
        'current_address',
        'current_city',
        'current_state',
        'current_pincode',
        'place_of_birth',
        'nationality',
        'marital_status_id',
        'spouse_name',
        'email',
        'pan',
        'aadhaar',
        'voter_id',
        'driving_license',
        'passport',
        'form_60',
        'status',
        'co_applicant_image'
    ];

    protected $casts = [
        'dob' => 'date',
        'form_60' => 'boolean',
    ];

    // Relationship to Applicant
    public function applicant()
    {
        return $this->belongsTo(Applicant::class);
    }

    // Relationships to FormField options
    public function caste()
    {
        return $this->belongsTo(FormField::class, 'caste_id');
    }

    public function gender()
    {
        return $this->belongsTo(FormField::class, 'gender_id');
    }

    public function addressType()
    {
        return $this->belongsTo(FormField::class, 'address_type_id');
    }

    public function maritalStatus()
    {
        return $this->belongsTo(FormField::class, 'marital_status_id');
    }
}