<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class City extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'state_id',
        'district_id',
        'status',
        'deleted_at'
    ];

    protected $casts = [
        'state_id' => 'integer',
        'district_id' => 'integer',
        'status' => 'integer',
        'deleted_at' => 'integer'
    ];

    /**
     * Get the state that owns the city
     */
    public function state()
    {
        return $this->belongsTo(State::class);
    }

    /**
     * Get the district that owns the city
     */
    public function district()
    {
        return $this->belongsTo(District::class);
    }
}