<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BankingInfo extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'banking_info';

    protected $fillable = [
        'banking_id',
        'applicant_id',
        'banking_type',
        'reference_1',
        'relation_with_applicant',
        'reference_2',
        'reference_2_relation',
        'reference_3'
    ];

    public function applicant()
    {
        return $this->belongsTo(Applicant::class);
    }
}