<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attendance extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'staff_id',
        'in_time',
        'out_time',
        'date',
        'working_hours',
        'in_time_status',
        'out_time_status',
        'in_time_lat',
        'in_time_long',
        'in_time_address',
        'out_time_lat',
        'out_time_long',
        'out_time_address',
    ];

    protected $casts = [
        'date' => 'date',
        'in_time' => 'datetime:H:i:s',
        'out_time' => 'datetime:H:i:s',
    ];

    /**
     * Get the user who owns this attendance record
     * Relationship: Each Attendance belongs to One User (based on staff_id)
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'staff_id', 'staff_id');
    }
}