<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApiLogs extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'log_type',
        'endpoint',
        'message',
        'data',
        'user_ip',
        'user_id',
        'device_info',
    ];

    protected $casts = [
        'data' => 'array',
        'device_info' => 'array',
    ];
}