<?php

namespace App\Helpers;

use App\Models\FormField;

class DynamicDropdownHelper
{
    /**
     * Get options for a specific field key
     */
    public static function getOptions($fieldKey)
    {
        $field = FormField::where('field_key', $fieldKey)
            ->where('status', 1)
            ->with(['options' => function($query) {
                $query->where('status', 1)->orderBy('sort_order');
            }])
            ->first();

        return $field ? $field->options : collect();
    }

    /**
     * Render dropdown HTML for a field
     */
    public static function renderDropdown($fieldKey, $name = null, $selected = null, $attributes = [])
    {
        $options = self::getOptions($fieldKey);
        $name = $name ?: $fieldKey;
        
        $html = '<select name="' . $name . '"';
        foreach ($attributes as $attr => $value) {
            $html .= ' ' . $attr . '="' . $value . '"';
        }
        $html .= '>';
        
        $html .= '<option value="">Select...</option>';
        foreach ($options as $option) {
            $selectedAttr = $selected == $option->option_value ? ' selected' : '';
            $html .= '<option value="' . $option->option_value . '"' . $selectedAttr . '>' . $option->option_label . '</option>';
        }
        
        $html .= '</select>';
        return $html;
    }
}